/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.io.IOUtils;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public abstract class DataMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = -2377505617785953620L;
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DataMailPart.class));
    private static final int MB = 0x100000;
    private byte[] bytes;
    private transient Object cachedContent;
    private transient DataSource dataSource;
    private ManagedFile file;
    private String fileId;
    private static final String TEXT = "text/";

    protected DataMailPart(Object data, Map<String, String> dataProperties, Session session) throws OXException {
        this.setHeaders(dataProperties);
        if (data instanceof InputStream) {
            long size;
            try {
                String sSize = dataProperties.get("com.openexchange.conversion.size");
                size = null == sSize ? 0L : Long.parseLong(sSize.trim());
                this.setSize(size);
            }
            catch (NumberFormatException e) {
                size = 0L;
            }
            this.handleInputStream((InputStream)data, size);
        } else if (data instanceof byte[]) {
            this.bytes = (byte[])data;
            this.setSize(this.bytes.length);
        } else {
            throw MailExceptionCode.UNSUPPORTED_DATASOURCE.create();
        }
    }

    private void applyByteContent(String charset) throws OXException {
        try {
            this.cachedContent = new String(this.bytes, Charsets.forName((String)charset));
        }
        catch (UnsupportedCharsetException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    private void applyFileContent(String charset) throws OXException {
        InputStream fis = null;
        try {
            fis = this.file.getInputStream();
            this.cachedContent = MessageUtility.readStream(fis, charset);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy2ByteArr(InputStream in) throws IOException {
        try {
            int len;
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
            byte[] bbuf = new byte[8192];
            while ((len = in.read(bbuf)) > 0) {
                out.write(bbuf, 0, len);
            }
            out.flush();
            this.bytes = out.toByteArray();
            this.setSize(this.bytes.length);
        }
        finally {
            IOUtils.closeStreamStuff(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy2File(InputStream in) throws IOException {
        try {
            ManagedFile mf;
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (null == mfm) {
                throw new IOException("Missing file management");
            }
            try {
                mf = mfm.createManagedFile(in);
            }
            catch (OXException e) {
                IOException ioerr = new IOException();
                ioerr.initCause(e);
                throw ioerr;
            }
            this.setSize(mf.getSize());
            this.file = mf;
            this.fileId = mf.getID();
        }
        finally {
            IOUtils.closeStreamStuff(in);
        }
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            if (this.bytes != null) {
                String charset = this.getContentType().getCharsetParameter();
                if (null == charset) {
                    charset = MailProperties.getInstance().getDefaultMimeCharset();
                }
                this.applyByteContent(charset);
                return this.cachedContent;
            }
            if (this.file != null) {
                String charset = this.getContentType().getCharsetParameter();
                if (null == charset) {
                    charset = System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset());
                }
                this.applyFileContent(charset);
                return this.cachedContent;
            }
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    private DataSource getDataSource() throws OXException {
        if (null == this.dataSource) {
            try {
                ContentType contentType = this.getContentType();
                if (this.bytes != null) {
                    if (contentType.startsWith(TEXT) && !contentType.containsCharsetParameter()) {
                        contentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                    }
                    this.dataSource = new MessageDataSource(this.bytes, contentType.toString());
                    return this.dataSource;
                }
                if (this.file != null) {
                    if (contentType.startsWith(TEXT) && !contentType.containsCharsetParameter()) {
                        contentType.setCharsetParameter(System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset()));
                    }
                    final ManagedFile managedFile = this.file;
                    final String fileName = this.getFileName();
                    StreamDataSource.InputStreamProvider isp = new StreamDataSource.InputStreamProvider(){

                        @Override
                        public InputStream getInputStream() throws IOException {
                            try {
                                return managedFile.getInputStream();
                            }
                            catch (OXException e) {
                                IOException err = new IOException();
                                err.initCause(e);
                                throw err;
                            }
                        }

                        @Override
                        public String getName() {
                            return fileName;
                        }
                    };
                    this.dataSource = new StreamDataSource(isp, contentType.toString());
                    return this.dataSource;
                }
                throw MailExceptionCode.NO_CONTENT.create();
            }
            catch (MailConfigException e) {
                LOG.error((Object)e.getMessage(), (Throwable)((Object)e));
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            if (this.bytes != null) {
                return new UnsynchronizedByteArrayInputStream(this.bytes);
            }
            if (this.file != null) {
                return this.file.getInputStream();
            }
            throw MailExceptionCode.NO_CONTENT.create();
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.DATA;
    }

    private void handleInputStream(InputStream inputStream, long size) throws OXException {
        try {
            if (size > 0L && size <= (long)TransportProperties.getInstance().getReferencedPartLimit()) {
                this.copy2ByteArr(inputStream);
                return;
            }
            this.copy2File(inputStream);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)new StringAllocator("Data mail part exeeds ").append(Float.valueOf(TransportProperties.getInstance().getReferencedPartLimit() / 0x100000).floatValue()).append("MB limit. A temporary disk copy has been created: ").append(this.file.getFile().getName()));
        }
    }

    @Override
    public void loadContent() throws OXException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"DataSourceMailPart.loadContent()");
        }
    }

    @Override
    public void prepareForCaching() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"DataSourceMailPart.prepareForCaching()");
        }
    }

    public String getFileID() {
        return this.fileId;
    }

    private void setHeaders(Map<String, String> dataProperties) throws OXException {
        String disp;
        ContentType contentType;
        String charset;
        String cts = dataProperties.get("com.openexchange.conversion.content-type");
        if (null != cts) {
            this.setContentType(cts);
        }
        if (null != (charset = dataProperties.get("com.openexchange.conversion.charset")) && (contentType = this.getContentType()).startsWith(TEXT)) {
            contentType.setCharsetParameter(charset);
        }
        if (null == (disp = dataProperties.get("com.openexchange.conversion.disposition"))) {
            this.getContentDisposition().setDisposition("attachment");
        } else {
            this.getContentDisposition().setDisposition(disp);
        }
        String fileName = dataProperties.get("com.openexchange.conversion.name");
        if (null != fileName) {
            this.getContentType().setNameParameter(fileName);
            this.getContentDisposition().setFilenameParameter(fileName);
        }
    }
}

