/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.session.Session;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class MailSessionCache {
    private final TIntObjectMap<ConcurrentMap<String, Object>> map = new TIntObjectHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailSessionCache getInstance(Session session) {
        if (null == session) {
            return null;
        }
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
        }
        if (null == mailCache) {
            Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
            if (null == lock) {
                lock = Session.EMPTY_LOCK;
            }
            lock.lock();
            try {
                mailCache = (MailSessionCache)session.getParameter(key);
                if (null == mailCache) {
                    mailCache = new MailSessionCache();
                    session.setParameter(key, (Object)mailCache);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return mailCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropInstance(Session session) {
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
            return;
        }
        if (null != mailCache) {
            Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
            if (null == lock) {
                lock = Session.EMPTY_LOCK;
            }
            lock.lock();
            try {
                mailCache = (MailSessionCache)session.getParameter(key);
                if (null != mailCache) {
                    mailCache.clear();
                    session.setParameter(key, null);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private MailSessionCache() {
    }

    public <T> T getParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return null;
        }
        try {
            Object retval = accountMap.get(parameterName);
            return (T)retval;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public boolean containsParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return false;
        }
        return accountMap.containsKey(parameterName);
    }

    public void putParameter(int accountId, String parameterName, Object parameterValue) {
        NonBlockingHashMap newInst;
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap && null == (accountMap = (ConcurrentMap)this.map.putIfAbsent(accountId, (Object)(newInst = new NonBlockingHashMap())))) {
            accountMap = newInst;
        }
        if (null == parameterValue) {
            accountMap.remove(parameterName);
        } else {
            accountMap.put(parameterName, parameterValue);
        }
    }

    public Object putParameterIfAbsent(int accountId, String parameterName, Object parameterValue) {
        NonBlockingHashMap newInst;
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap && null == (accountMap = (ConcurrentMap)this.map.putIfAbsent(accountId, (Object)(newInst = new NonBlockingHashMap())))) {
            accountMap = newInst;
        }
        if (null == parameterValue) {
            return accountMap.remove(parameterName);
        }
        return accountMap.putIfAbsent(parameterName, parameterValue);
    }

    public Object removeParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return null;
        }
        return accountMap.remove(parameterName);
    }

    public void removeAccountParameters(int accountId) {
        ConcurrentMap removed = (ConcurrentMap)this.map.remove(accountId);
        if (null != removed) {
            removed.clear();
        }
    }

    public void clear() {
        this.map.clear();
    }
}

