/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailAccessWatcher;
import com.openexchange.mail.attachment.AttachmentTokenRegistry;
import com.openexchange.mail.cache.EnqueueingMailAccessCache;
import com.openexchange.mail.cache.MailCacheConfiguration;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.cache.SingletonMailAccessCache;
import com.openexchange.mail.config.MailPropertiesInit;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.Initialization;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.apache.commons.logging.Log;

public final class MailInitialization
implements Initialization,
CacheAvailabilityListener {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailInitialization.class));
    private static final MailInitialization instance = new MailInitialization();
    private final AtomicBoolean started = new AtomicBoolean();

    private MailInitialization() {
    }

    public static MailInitialization getInstance() {
        return instance;
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn((Object)"Duplicate initialization of mail module aborted.");
            return;
        }
        Stack<Initialization> startedStack = new Stack<Initialization>();
        try {
            this.startUp(MailPropertiesInit.getInstance(), startedStack);
            this.startUp(MailCacheConfiguration.getInstance(), startedStack);
            this.startUp(new Initialization(){

                public void start() throws OXException {
                    MailAccessWatcher.init();
                }

                public void stop() {
                    MailAccessWatcher.stop();
                }
            }, startedStack);
            this.startUp(new Initialization(){

                public void start() throws OXException {
                    EventPool.initInstance();
                }

                public void stop() {
                    EventPool.releaseInstance();
                }
            }, startedStack);
            this.startUp(new Initialization(){

                public void stop() {
                }

                public void start() {
                    MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
                    mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
                    mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
                    mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
                    mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed; x-java-fallback-entry=true");
                    mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
                    CommandMap.setDefaultCommandMap((CommandMap)mc);
                }
            }, startedStack);
            CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
            if (null != reg) {
                reg.registerListener(this);
                reg.registerListener(UserSettingMailStorage.getInstance());
            }
        }
        catch (OXException e) {
            this.started.set(false);
            for (Initialization startedInit : startedStack) {
                try {
                    startedInit.stop();
                }
                catch (Exception e1) {
                    LOG.error((Object)"Initialization could not be revoked", (Throwable)e1);
                }
            }
            throw e;
        }
    }

    private void startUp(Initialization initialization, Stack<Initialization> startedStack) throws OXException {
        initialization.start();
        startedStack.push(initialization);
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn((Object)"Duplicate shut-down of mail module aborted.");
            return;
        }
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this);
            reg.unregisterListener(UserSettingMailStorage.getInstance());
        }
        AttachmentTokenRegistry.releaseInstance();
        EventPool.releaseInstance();
        MimeType2ExtMap.reset();
        EnqueueingMailAccessCache.releaseInstance();
        SingletonMailAccessCache.releaseInstance();
        MailMessageCache.releaseInstance();
        UserSettingMailStorage.releaseInstance();
        MailAccessWatcher.stop();
        MailCacheConfiguration.getInstance().stop();
        MailPropertiesInit.getInstance().stop();
    }

    public void shutDownCaches() throws OXException {
        MailMessageCache.getInstance().releaseCache();
        MailCacheConfiguration.getInstance().stop();
    }

    public void startUpCaches() throws OXException {
        MailCacheConfiguration.getInstance().start();
        MailMessageCache.getInstance().initCache();
    }

    @Override
    public void handleAbsence() throws OXException {
        this.shutDownCaches();
    }

    @Override
    public void handleAvailability() throws OXException {
        this.startUpCaches();
    }

    public boolean isInitialized() {
        return this.started.get();
    }
}

