/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache.impl;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.json.cache.JsonCacheService;
import com.openexchange.json.cache.JsonCaches;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.sql.DBUtils;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public final class JsonCacheServiceImpl
implements JsonCacheService {
    private static final Charset US_ASCII = Charsets.US_ASCII;
    private static final Charset UTF8 = Charsets.UTF_8;
    private final ServiceLookup services;

    public JsonCacheServiceImpl(ServiceLookup services) {
        this.services = services;
    }

    public JSONValue get(String id, int userId, int contextId) throws OXException {
        JSONValue ret = this.opt(id, userId, contextId);
        if (null == ret) {
            throw AjaxExceptionCodes.JSON_ERROR.create(id);
        }
        return ret;
    }

    public JSONValue opt(String id, int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block13: {
            String sJson;
            block12: {
                block11: {
                    block10: {
                        con = Database.get(contextId, false);
                        stmt = null;
                        rs = null;
                        stmt = con.prepareStatement("SELECT json FROM jsonCache WHERE cid=? AND user=? AND id=?");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, userId);
                        stmt.setString(3, id);
                        rs = stmt.executeQuery();
                        if (rs.next()) break block10;
                        JSONValue jSONValue = null;
                        DBUtils.closeSQLStuff(rs, stmt);
                        Database.back(contextId, false, con);
                        return jSONValue;
                    }
                    sJson = rs.getString(1);
                    if (!"null".equals(sJson)) break block11;
                    JSONValue jSONValue = null;
                    DBUtils.closeSQLStuff(rs, stmt);
                    Database.back(contextId, false, con);
                    return jSONValue;
                }
                if ('{' != sJson.charAt(0)) break block12;
                JSONObject jSONObject = new JSONObject(sJson);
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                return jSONObject;
            }
            if ('[' != sJson.charAt(0)) break block13;
            JSONArray jSONArray = new JSONArray(sJson);
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            return jSONArray;
        }
        try {
            try {
                throw AjaxExceptionCodes.JSON_ERROR.create("Not a JSON value.");
            }
            catch (SQLException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
            }
            catch (RuntimeException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            throw throwable;
        }
    }

    public void delete(String id, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, true);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM jsonCache WHERE cid=? AND user=? AND id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            Database.back(contextId, true, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(String id, JSONValue jsonValue, long duration, int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block12: {
            con = Database.get(contextId, true);
            stmt = null;
            rs = null;
            if (null != jsonValue) break block12;
            stmt = con.prepareStatement("DELETE FROM jsonCache WHERE cid=? AND user=? AND id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, true, con);
            return;
        }
        try {
            stmt = con.prepareStatement("SELECT 1 FROM jsonCache WHERE cid=? AND user=? AND id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            rs = stmt.executeQuery();
            boolean update = rs.next();
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            long now = System.currentTimeMillis();
            String asciiOnly = JsonCacheServiceImpl.toJavaNotation(jsonValue.toString());
            if (update) {
                stmt = con.prepareStatement("UPDATE jsonCache SET json=?, size=?, lastUpdate=?, took=? WHERE cid=? AND user=? AND id=?");
                stmt.setString(1, asciiOnly);
                stmt.setLong(2, jsonValue.length());
                stmt.setLong(3, now);
                if (duration < 0L) {
                    stmt.setNull(4, -5);
                } else {
                    stmt.setLong(4, duration);
                }
                stmt.setInt(5, contextId);
                stmt.setInt(6, userId);
                stmt.setString(7, id);
            } else {
                stmt = con.prepareStatement("INSERT INTO jsonCache (cid,user,id,json,size,lastUpdate,took) VALUES (?,?,?,?,?,?,?)");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, id);
                stmt.setString(4, asciiOnly);
                stmt.setLong(5, jsonValue.length());
                stmt.setLong(6, now);
                if (duration < 0L) {
                    stmt.setNull(7, -5);
                } else {
                    stmt.setLong(7, duration);
                }
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, true, con);
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setIfDifferent(String id, JSONValue jsonValue, long duration, int userId, int contextId) throws OXException {
        boolean bl;
        boolean update;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block21: {
            JSONObject prev;
            block24: {
                block22: {
                    String sJson;
                    block23: {
                        if (null == jsonValue) {
                            return false;
                        }
                        con = Database.get(contextId, true);
                        stmt = null;
                        rs = null;
                        stmt = con.prepareStatement("SELECT json FROM jsonCache WHERE cid=? AND user=? AND id=?");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, userId);
                        stmt.setString(3, id);
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block22;
                        update = true;
                        sJson = rs.getString(1);
                        if (!rs.wasNull()) break block23;
                        prev = null;
                        break block24;
                    }
                    if ("null".equalsIgnoreCase(sJson)) {
                        prev = null;
                        break block24;
                    } else {
                        JSONObject tmp;
                        try {
                            if ('{' == sJson.charAt(0)) {
                                tmp = new JSONObject(sJson);
                            } else {
                                if ('[' != sJson.charAt(0)) {
                                    throw AjaxExceptionCodes.JSON_ERROR.create("Not a JSON value: " + JsonCacheServiceImpl.abbreviate(sJson, 0, 256));
                                }
                                tmp = new JSONArray(sJson);
                            }
                        }
                        catch (JSONException e) {
                            tmp = null;
                        }
                        prev = tmp;
                    }
                    break block24;
                }
                prev = null;
                update = false;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            rs = null;
            if (!JsonCaches.areEqual(prev, (JSONValue)jsonValue)) break block21;
            boolean sJson = false;
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, true, con);
            return sJson;
        }
        try {
            String asciiOnly = JsonCacheServiceImpl.toJavaNotation(jsonValue.toString());
            long now = System.currentTimeMillis();
            if (update) {
                stmt = con.prepareStatement("UPDATE jsonCache SET json=?, size=?, lastUpdate=?, took=? WHERE cid=? AND user=? AND id=?");
                stmt.setString(1, asciiOnly);
                stmt.setLong(2, jsonValue.length());
                stmt.setLong(3, now);
                if (duration < 0L) {
                    stmt.setNull(4, -5);
                } else {
                    stmt.setLong(4, duration);
                }
                stmt.setInt(5, contextId);
                stmt.setInt(6, userId);
                stmt.setString(7, id);
            } else {
                stmt = con.prepareStatement("INSERT INTO jsonCache (cid,user,id,json,size,lastUpdate,took) VALUES (?,?,?,?,?,?,?)");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, id);
                stmt.setString(4, asciiOnly);
                stmt.setLong(5, jsonValue.length());
                stmt.setLong(6, now);
                if (duration < 0L) {
                    stmt.setNull(7, -5);
                } else {
                    stmt.setLong(7, duration);
                }
            }
            stmt.executeUpdate();
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, true, con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lock(String id, int userId, int contextId) throws OXException {
        boolean bl;
        long now;
        boolean transactional;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block13: {
            boolean inserted;
            con = Database.get(contextId, true);
            stmt = null;
            rs = null;
            transactional = false;
            DBUtils.startTransaction(con);
            transactional = true;
            stmt = con.prepareStatement("SELECT 1 FROM jsonCache WHERE cid=? AND user=? AND id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            rs = stmt.executeQuery();
            boolean update = rs.next();
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            now = System.currentTimeMillis();
            if (update) break block13;
            stmt = con.prepareStatement("INSERT INTO jsonCache (cid,user,id,json,size,inProgress,inProgressSince,lastUpdate) VALUES (?,?,?,?,?,1,?,?)");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            stmt.setString(4, "null");
            stmt.setLong(5, 0L);
            stmt.setLong(6, now);
            stmt.setLong(7, now);
            try {
                inserted = stmt.executeUpdate() > 0;
            }
            catch (Exception e) {
                inserted = false;
            }
            if (!inserted) break block13;
            boolean bl2 = true;
            DBUtils.closeSQLStuff(rs, stmt);
            if (transactional) {
                DBUtils.autocommit(con);
            }
            Database.back(contextId, true, con);
            return bl2;
        }
        try {
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement("UPDATE jsonCache SET inProgress=1, inProgressSince=? WHERE cid=? AND user=? AND id=? AND inProgress=0");
            stmt.setLong(1, now);
            stmt.setInt(2, contextId);
            stmt.setInt(3, userId);
            stmt.setString(4, id);
            boolean updated = stmt.executeUpdate() > 0;
            con.commit();
            bl = updated;
        }
        catch (SQLException e) {
            try {
                if (transactional) {
                    DBUtils.rollback(con);
                }
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    if (transactional) {
                        DBUtils.rollback(con);
                    }
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (transactional) {
                    DBUtils.autocommit(con);
                }
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (transactional) {
            DBUtils.autocommit(con);
        }
        Database.back(contextId, true, con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock(String id, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, true);
        PreparedStatement stmt = null;
        boolean transactional = false;
        try {
            DBUtils.startTransaction(con);
            transactional = true;
            stmt = con.prepareStatement("UPDATE jsonCache SET inProgress=0 WHERE cid=? AND user=? AND id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, id);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            try {
                if (transactional) {
                    DBUtils.rollback(con);
                }
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    if (transactional) {
                        DBUtils.rollback(con);
                    }
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                if (transactional) {
                    DBUtils.autocommit(con);
                }
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (transactional) {
            DBUtils.autocommit(con);
        }
        Database.back(contextId, true, con);
    }

    private static String toJavaNotation(String unicode) {
        int length = unicode.length();
        StringBuilder sb = new StringBuilder(length << 1);
        for (int i = 0; i < length; ++i) {
            char a = unicode.charAt(i);
            if (a > '\u007f') {
                String hexString = Integer.toHexString(a);
                sb.append("\\u");
                if (2 == hexString.length()) {
                    sb.append("00");
                }
                sb.append(hexString);
                continue;
            }
            sb.append(a);
        }
        return sb.toString();
    }

    private static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length <= maxWidth) {
            return str;
        }
        int off = offset;
        if (off > length) {
            off = length;
        }
        if (length - off < maxWidth - 3) {
            off = length - (maxWidth - 3);
        }
        if (off <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (off + (maxWidth - 3) < length) {
            return "..." + JsonCacheServiceImpl.abbreviate(str.substring(off), 0, maxWidth - 3);
        }
        return "..." + str.substring(length - (maxWidth - 3));
    }
}

