/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public final class UserConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8277899698366715803L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UserConfiguration.class));
    public static final int WEBMAIL = 1;
    public static final int CALENDAR = 2;
    public static final int CONTACTS = 4;
    public static final int TASKS = 8;
    public static final int INFOSTORE = 16;
    public static final int PROJECTS = 32;
    public static final int FORUM = 64;
    public static final int PINBOARD_WRITE_ACCESS = 128;
    public static final int WEBDAV_XML = 256;
    public static final int WEBDAV = 512;
    public static final int ICAL = 1024;
    public static final int VCARD = 2048;
    public static final int RSS_BOOKMARKS = 4096;
    public static final int RSS_PORTAL = 8192;
    public static final int MOBILITY = 16384;
    public static final int EDIT_PUBLIC_FOLDERS = 32768;
    public static final int READ_CREATE_SHARED_FOLDERS = 65536;
    public static final int DELEGATE_TASKS = 131072;
    public static final int EDIT_GROUP = 262144;
    public static final int EDIT_RESOURCE = 524288;
    public static final int EDIT_PASSWORD = 0x100000;
    public static final int COLLECT_EMAIL_ADDRESSES = 0x200000;
    public static final int MULTIPLE_MAIL_ACCOUNTS = 0x400000;
    public static final int SUBSCRIPTION = 0x800000;
    public static final int PUBLICATION = 0x1000000;
    public static final int ACTIVE_SYNC = 0x2000000;
    public static final int USM = 0x4000000;
    public static final int OLOX20 = 0x8000000;
    public static final int DENIED_PORTAL = 0x10000000;
    public static final int CALDAV = 0x20000000;
    public static final int CARDDAV = 0x40000000;
    private int permissionBits;
    private final int userId;
    private int[] groups;
    private final Context ctx;
    private volatile Set<String> extendedPermissions;
    private static final String PERMISSION_PROPERTY = "permissions".intern();
    private static final Pattern P_SPLIT = Pattern.compile("\\s*[, ]\\s*");

    public UserConfiguration(int permissionBits, int userId, int[] groups, Context ctx) {
        this.permissionBits = permissionBits;
        this.userId = userId;
        if (null == groups) {
            this.groups = null;
        } else {
            this.groups = new int[groups.length];
            System.arraycopy(groups, 0, this.groups, 0, groups.length);
        }
        this.ctx = ctx;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof UserConfiguration)) {
            return false;
        }
        UserConfiguration uc = (UserConfiguration)other;
        if (this.userId != uc.userId || !((Object)this.getExtendedPermissions()).equals(uc.getExtendedPermissions())) {
            return false;
        }
        if (null != this.groups) {
            if (null == uc.groups) {
                return false;
            }
            Arrays.sort(this.groups);
            Arrays.sort(uc.groups);
            if (!Arrays.equals(this.groups, uc.groups)) {
                return false;
            }
        }
        if (null != uc.groups) {
            return false;
        }
        if (null != this.ctx) {
            if (null == uc.ctx) {
                return false;
            }
            return this.ctx.getContextId() == uc.ctx.getContextId();
        }
        return null == uc.ctx;
    }

    void setExtendedPermissions(Set<String> extendedPermissions) {
        this.extendedPermissions = extendedPermissions;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.userId;
        for (String p : this.getExtendedPermissions()) {
            hash = 31 * hash + p.hashCode();
        }
        if (null != this.groups) {
            Arrays.sort(this.groups);
            for (int i = 0; i < this.groups.length; ++i) {
                hash = 31 * hash + this.groups[i];
            }
        }
        if (null != this.ctx) {
            hash = 31 * hash + this.ctx.getContextId();
        }
        return hash;
    }

    public Object clone() {
        try {
            UserConfiguration clone = (UserConfiguration)super.clone();
            if (this.groups != null) {
                clone.groups = new int[this.groups.length];
                System.arraycopy(this.groups, 0, clone.groups, 0, this.groups.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new InternalError(e.getMessage());
        }
    }

    public int getPermissionBits() {
        return this.permissionBits;
    }

    public void setPermissionBits(int permissionBits) {
        this.permissionBits = permissionBits;
    }

    public boolean hasWebMail() {
        return this.hasPermission(1);
    }

    public void setWebMail(boolean enableWebMail) {
        this.setPermission(enableWebMail, 1);
    }

    public boolean hasCalendar() {
        return this.hasPermission(2);
    }

    public void setCalendar(boolean enableCalender) {
        this.setPermission(enableCalender, 2);
    }

    public boolean hasContact() {
        return this.hasPermission(4);
    }

    public void setContact(boolean enableContact) {
        this.setPermission(enableContact, 4);
    }

    public boolean hasTask() {
        return this.hasPermission(8);
    }

    public void setTask(boolean enableTask) {
        this.setPermission(enableTask, 8);
    }

    public boolean hasInfostore() {
        return this.hasPermission(16);
    }

    public void setInfostore(boolean enableInfostore) {
        this.setPermission(enableInfostore, 16);
    }

    public boolean hasProject() {
        return this.hasPermission(32);
    }

    public void setProject(boolean enableProject) {
        this.setPermission(enableProject, 32);
    }

    public boolean hasForum() {
        return this.hasPermission(64);
    }

    public void setForum(boolean enableForum) {
        this.setPermission(enableForum, 64);
    }

    public boolean hasPinboardWriteAccess() {
        return this.hasPermission(128);
    }

    public void setPinboardWriteAccess(boolean enablePinboardWriteAccess) {
        this.setPermission(enablePinboardWriteAccess, 128);
    }

    public boolean hasWebDAVXML() {
        return this.hasPermission(256);
    }

    public void setWebDAVXML(boolean enableWebDAVXML) {
        this.setPermission(enableWebDAVXML, 256);
    }

    public boolean hasWebDAV() {
        return this.hasPermission(512);
    }

    public void setWebDAV(boolean enableWebDAV) {
        this.setPermission(enableWebDAV, 512);
    }

    public boolean hasICal() {
        return this.hasPermission(1024);
    }

    public void setICal(boolean enableICal) {
        this.setPermission(enableICal, 1024);
    }

    public boolean hasVCard() {
        return this.hasPermission(2048);
    }

    public void setVCard(boolean enableVCard) {
        this.setPermission(enableVCard, 2048);
    }

    public boolean hasRSSBookmarks() {
        return this.hasPermission(4096);
    }

    public void setRSSBookmarks(boolean enableRSSBookmarks) {
        this.setPermission(enableRSSBookmarks, 4096);
    }

    public boolean hasRSSPortal() {
        return this.hasPermission(8192);
    }

    public void setRSSPortal(boolean enableRSSPortal) {
        this.setPermission(enableRSSPortal, 8192);
    }

    public boolean hasSyncML() {
        return this.hasPermission(16384);
    }

    public void setSyncML(boolean enableSyncML) {
        this.setPermission(enableSyncML, 16384);
    }

    public boolean hasPIM() {
        return this.hasCalendar() && this.hasContact() && this.hasTask();
    }

    public boolean hasTeamView() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasFreeBusy() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasConflictHandling() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasParticipantsDialog() {
        return this.hasConflictHandling();
    }

    public boolean hasPortal() {
        return !this.hasPermission(0x10000000);
    }

    public void setDeniedPortal(boolean deniedPortal) {
        this.setPermission(deniedPortal, 0x10000000);
    }

    public int[] getAccessibleModules() {
        TIntArrayList array = new TIntArrayList(10);
        if (this.hasTask()) {
            array.add(1);
        }
        if (this.hasCalendar()) {
            array.add(2);
        }
        if (this.hasContact()) {
            array.add(3);
        }
        array.add(4);
        array.add(5);
        if (this.hasProject()) {
            array.add(6);
        }
        if (this.hasWebMail()) {
            array.add(7);
        }
        if (this.hasInfostore()) {
            array.add(8);
        }
        array.add(13);
        array.add(14);
        return array.toArray();
    }

    public boolean hasModuleAccess(int module) {
        return Arrays.binarySearch(this.getAccessibleModules(), module) >= 0;
    }

    public boolean hasFullPublicFolderAccess() {
        return this.hasPermission(32768);
    }

    public void setFullPublicFolderAccess(boolean enableFullPublicFolderAccess) {
        this.setPermission(enableFullPublicFolderAccess, 32768);
    }

    public boolean hasFullSharedFolderAccess() {
        return this.hasPermission(65536);
    }

    public void setFullSharedFolderAccess(boolean enableFullSharedFolderAccess) {
        this.setPermission(enableFullSharedFolderAccess, 65536);
    }

    public boolean canDelegateTasks() {
        return this.hasPermission(131072);
    }

    public void setDelegateTasks(boolean enableDelegateTasks) {
        this.setPermission(enableDelegateTasks, 131072);
    }

    public boolean isCollectEmailAddresses() {
        return this.hasPermission(0x200000);
    }

    public void setCollectEmailAddresses(boolean collectEmailAddresses) {
        this.setPermission(collectEmailAddresses, 0x200000);
    }

    public boolean isMultipleMailAccounts() {
        return this.hasPermission(0x400000);
    }

    public void setMultipleMailAccounts(boolean multipleMailAccounts) {
        this.setPermission(multipleMailAccounts, 0x400000);
    }

    public boolean isSubscription() {
        return this.hasPermission(0x800000);
    }

    public void setSubscription(boolean subscription) {
        this.setPermission(subscription, 0x800000);
    }

    public boolean isPublication() {
        return this.hasPermission(0x1000000);
    }

    public void setPublication(boolean publication) {
        this.setPermission(publication, 0x1000000);
    }

    public boolean hasActiveSync() {
        return this.hasPermission(0x2000000);
    }

    public void setActiveSync(boolean eas) {
        this.setPermission(eas, 0x2000000);
    }

    public boolean hasUSM() {
        return this.hasPermission(0x4000000);
    }

    public void setUSM(boolean usm) {
        this.setPermission(usm, 0x4000000);
    }

    public boolean hasOLOX20() {
        return this.hasPermission(0x8000000);
    }

    public void setOLOX20(boolean olox20) {
        this.setPermission(olox20, 0x8000000);
    }

    public boolean isEditGroup() {
        return this.hasPermission(262144);
    }

    public void setEditGroup(boolean editGroup) {
        this.setPermission(editGroup, 262144);
    }

    public boolean isEditResource() {
        return this.hasPermission(524288);
    }

    public void setEditResource(boolean editResource) {
        this.setPermission(editResource, 524288);
    }

    public boolean isEditPassword() {
        return this.hasPermission(0x100000);
    }

    public void setEditPassword(boolean editPassword) {
        this.setPermission(editPassword, 0x100000);
    }

    public boolean hasPermission(int permissionBit) {
        if (permissionBit == 0) {
            return true;
        }
        List<Permission> permission = Permission.byBits(permissionBit);
        Set<String> extendedPermissions = this.getExtendedPermissions();
        for (Permission p : permission) {
            if (extendedPermissions.contains(p.name().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public boolean hasPermission(Permission permission) {
        if (null == permission) {
            return false;
        }
        return this.hasPermissionInternal(permission);
    }

    public boolean hasPermission(String name) {
        return this.getExtendedPermissions().contains(name.toLowerCase());
    }

    private boolean hasPermissionInternal(int permission) {
        return (this.permissionBits & permission) == permission;
    }

    private boolean hasPermissionInternal(Permission permission) {
        return this.hasPermissionInternal(permission.bit);
    }

    private void setPermission(boolean enable, int permission) {
        this.permissionBits = enable ? this.permissionBits | permission : this.permissionBits & ~permission;
    }

    public int getUserId() {
        return this.userId;
    }

    public int[] getGroups() {
        if (null == this.groups) {
            return null;
        }
        int[] clone = new int[this.groups.length];
        System.arraycopy(this.groups, 0, clone, 0, clone.length);
        return clone;
    }

    public Context getContext() {
        return this.ctx;
    }

    public String toString() {
        return new StringBuilder(32).append("UserConfiguration_").append(this.userId).append('@').append(Integer.toBinaryString(this.permissionBits)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getExtendedPermissions() {
        Set<String> retval = this.extendedPermissions;
        if (retval == null) {
            UserConfiguration lock;
            UserConfigurationStorage configurationStorage = UserConfigurationStorage.getInstance();
            UserConfiguration userConfiguration = lock = null == configurationStorage ? this : configurationStorage.getLock(this.userId, this.ctx);
            synchronized (userConfiguration) {
                retval = this.extendedPermissions;
                if (retval == null) {
                    retval = new HashSet<String>();
                    for (Permission p : Permission.values()) {
                        if (!this.hasPermissionInternal(p)) continue;
                        retval.add(p.name().toLowerCase());
                    }
                    ConfigViewFactory configViews = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
                    if (configViews != null) {
                        try {
                            String[] searchPath;
                            ConfigView view = configViews.getView(this.getUserId(), this.getContext().getContextId());
                            for (String scope : searchPath = configViews.getSearchPath()) {
                                String permissions = (String)view.property(PERMISSION_PROPERTY, String.class).precedence(new String[]{scope}).get();
                                if (permissions == null) continue;
                                for (String permissionModifier : P_SPLIT.split(permissions)) {
                                    char firstChar = permissionModifier.charAt(0);
                                    if ('-' == firstChar) {
                                        retval.remove(permissionModifier.substring(1).toLowerCase());
                                        continue;
                                    }
                                    if ('+' == firstChar) {
                                        permissionModifier = permissionModifier.substring(1);
                                    }
                                    retval.add(permissionModifier.toLowerCase());
                                }
                            }
                        }
                        catch (OXException x) {
                            LOG.error((Object)x.getMessage(), (Throwable)x);
                        }
                    }
                    if (null != configurationStorage) {
                        configurationStorage.setExtendedPermissions(retval, this.userId, this.ctx);
                    }
                    this.extendedPermissions = retval;
                }
            }
        }
        return retval;
    }

    public static enum Permission {
        WEBMAIL(1, "WebMail"),
        CALENDAR(2, "Calendar"),
        CONTACTS(4, "Contacts"),
        TASKS(8, "Tasks"),
        INFOSTORE(16, "Infostore"),
        PROJECTS(32, "Projects"),
        FORUM(64, "Forum"),
        PINBOARD_WRITE_ACCESS(128, "PinboardWriteAccess"),
        WEBDAV_XML(256, "WebDAVXML"),
        WEBDAV(512, "WebDAV"),
        ICAL(1024, "ICal"),
        VCARD(2048, "VCard"),
        RSS_BOOKMARKS(4096, "RSSBookmarks"),
        RSS_PORTAL(8192, "RSSPortal"),
        MOBILITY(16384, "SyncML"),
        EDIT_PUBLIC_FOLDERS(32768, "FullPublicFolderAccess"),
        READ_CREATE_SHARED_FOLDERS(65536, "FullSharedFolderAccess"),
        DELEGATE_TASKS(131072, "DelegateTasks"),
        EDIT_GROUP(262144, "EditGroup"),
        EDIT_RESOURCE(524288, "EditResource"),
        EDIT_PASSWORD(0x100000, "EditPassword"),
        COLLECT_EMAIL_ADDRESSES(0x200000, "CollectEMailAddresses"),
        MULTIPLE_MAIL_ACCOUNTS(0x400000, "MultipleMailAccounts"),
        SUBSCRIPTION(0x800000, "Subscription"),
        PUBLICATION(0x1000000, "Publication"),
        ACTIVE_SYNC(0x2000000, "ActiveSync"),
        USM(0x4000000, "USM"),
        OLOX20(0x8000000, "OLOX20"),
        DENIED_PORTAL(0x10000000, "DeniedPortal"),
        CALDAV(0x20000000, "CalDAV"),
        CARDDAV(0x40000000, "CardDAV");

        private static TIntObjectMap<Permission> byBit;
        int bit;
        String tagName;

        private Permission(int bit, String name) {
            this.bit = bit;
            this.tagName = name;
        }

        public int getBit() {
            return this.bit;
        }

        public static Permission byBit(int permission) {
            return (Permission)((Object)byBit.get(permission));
        }

        public String getTagName() {
            return this.tagName;
        }

        public static List<Permission> byBits(int permissionBit) {
            Permission[] pa = Permission.values();
            ArrayList<Permission> permissions = new ArrayList<Permission>(pa.length);
            for (Permission p : pa) {
                int bit = p.bit;
                if ((permissionBit & bit) != bit) continue;
                permissions.add(p);
            }
            return permissions;
        }

        static {
            Permission[] permissions = Permission.values();
            TIntObjectHashMap m = new TIntObjectHashMap(permissions.length);
            for (Permission p : permissions) {
                m.put(p.bit, (Object)p);
            }
            byBit = m;
        }
    }
}

