/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.impl;

import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UploadEvent {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UploadEvent.class));
    public static final int MAIL_UPLOAD = 1;
    public static final int APPOINTMENT_UPLOAD = 2;
    public static final int TASK_UPLOAD = 3;
    public static final int CONTACT_UPLOAD = 4;
    public static final int DOCUMENT_UPLOAD = 5;
    private int affiliationId = -1;
    private final Map<String, UploadFile> uploadFiles = new HashMap<String, UploadFile>();
    private final Map<String, String> formFields = new HashMap<String, String>();
    private String action;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private List<UploadFile> sequentialList;
    private static final String ERR_PREFIX = "Temporary upload file could not be deleted: ";

    public final int getAffiliationId() {
        return this.affiliationId;
    }

    public final void setAffiliationId(int affiliationId) {
        this.affiliationId = affiliationId;
    }

    public final void addUploadFile(UploadFile uploadFile) {
        if (this.sequentialList != null) {
            this.sequentialList = null;
        }
        if (this.uploadFiles.containsKey(uploadFile.getFileName())) {
            UploadFile current = this.uploadFiles.get(uploadFile.getFileName());
            while (current.getHomonymous() != null) {
                current = current.getHomonymous();
            }
            current.setHomonymous(uploadFile);
        } else {
            this.uploadFiles.put(uploadFile.getFileName(), uploadFile);
        }
    }

    public final void removeUploadFile(String fileName) {
        if (this.sequentialList != null) {
            this.sequentialList = null;
        }
        for (UploadFile uploadFile = this.uploadFiles.remove(fileName); uploadFile != null; uploadFile = uploadFile.getHomonymous()) {
            if (!uploadFile.getTmpFile().exists()) continue;
            try {
                if (uploadFile.getTmpFile().delete()) continue;
                LOG.error((Object)new StringBuilder(ERR_PREFIX).append(uploadFile.getTmpFile().getName()));
                continue;
            }
            catch (SecurityException e) {
                LOG.error((Object)new StringBuilder(ERR_PREFIX).append(uploadFile.getTmpFile().getName()), (Throwable)e);
            }
        }
    }

    public final UploadFile getUploadFile(String fileName) {
        return this.uploadFiles.get(fileName);
    }

    public final UploadFile getUploadFileByFieldName(String fieldName) {
        int size = this.uploadFiles.size();
        Iterator<Map.Entry<String, UploadFile>> iter = this.uploadFiles.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            for (UploadFile uf = iter.next().getValue(); uf != null; uf = uf.getHomonymous()) {
                if (!uf.getFieldName().equalsIgnoreCase(fieldName)) continue;
                return uf;
            }
        }
        return null;
    }

    public final void clearUploadFiles() {
        this.cleanUp();
    }

    public final int getNumberOfUploadFiles() {
        return this.createList().size();
    }

    public final Iterator<UploadFile> getUploadFilesIterator() {
        return this.createList().iterator();
    }

    public final List<UploadFile> getUploadFiles() {
        return this.createList();
    }

    private final List<UploadFile> createList() {
        if (this.sequentialList != null) {
            return this.sequentialList;
        }
        int size = this.uploadFiles.size();
        if (size == 0) {
            return new ArrayList<UploadFile>(0);
        }
        this.sequentialList = new ArrayList<UploadFile>(size);
        Iterator<Map.Entry<String, UploadFile>> iter = this.uploadFiles.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            for (UploadFile uf = iter.next().getValue(); uf != null; uf = uf.getHomonymous()) {
                this.sequentialList.add(uf);
            }
        }
        return this.sequentialList;
    }

    public final void addFormField(String fieldName, String fieldValue) {
        this.formFields.put(fieldName, fieldValue);
    }

    public final String removeFormField(String fieldName) {
        return this.formFields.remove(fieldName);
    }

    public final String getFormField(String fieldName) {
        return this.formFields.get(fieldName);
    }

    public final void clearFormFields() {
        this.formFields.clear();
    }

    public final Iterator<String> getFormFieldNames() {
        return this.formFields.keySet().iterator();
    }

    public final String getAction() {
        return this.action;
    }

    public final void setAction(String action) {
        this.action = action;
    }

    public final Object getParameter(String name) {
        return name == null ? null : this.parameters.get(name);
    }

    public final void setParameter(String name, Object value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
    }

    public final void removeParameter(String name) {
        if (name != null) {
            this.parameters.remove(name);
        }
    }

    public final void cleanUp() {
        List<UploadFile> l = this.createList();
        int size = l.size();
        Iterator<UploadFile> iter = l.iterator();
        for (int i = 0; i < size; ++i) {
            UploadFile uploadFile = iter.next();
            File tmpFile = uploadFile.getTmpFile();
            if (!tmpFile.exists()) continue;
            try {
                if (tmpFile.delete()) continue;
                LOG.error((Object)new StringBuilder(ERR_PREFIX).append(tmpFile.getName()));
                continue;
            }
            catch (SecurityException e) {
                LOG.error((Object)new StringBuilder(ERR_PREFIX).append(tmpFile.getName()), (Throwable)e);
            }
        }
        this.uploadFiles.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Upload event cleaned-up. All temporary stored files deleted.");
        }
    }

    public static final String getFileName(String filePath) {
        String retval = filePath;
        int pos = retval.lastIndexOf(92);
        if (pos > -1) {
            retval = retval.substring(pos + 1);
        } else {
            pos = retval.lastIndexOf(47);
            if (pos > -1) {
                retval = retval.substring(pos + 1);
            }
        }
        return retval;
    }
}

