/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools.console;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.tools.Constants;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class UpdateTaskForceCLT {
    private static final Options toolkitOptions = new Options();

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("forceupdatetask", toolkitOptions);
    }

    private UpdateTaskForceCLT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        int contextId = -1;
        String schemaName = null;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                UpdateTaskForceCLT.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    UpdateTaskForceCLT.printHelp();
                    System.exit(0);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    UpdateTaskForceCLT.printHelp();
                    System.exit(0);
                }
            }
            String className = null;
            if (!cmd.hasOption('t')) {
                System.err.println("Missing update task's class name.");
                UpdateTaskForceCLT.printHelp();
                System.exit(0);
            } else {
                className = cmd.getOptionValue('t');
            }
            if (cmd.hasOption('c')) {
                String optionValue = cmd.getOptionValue('c');
                try {
                    contextId = Integer.parseInt(optionValue.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Context identifier parameter is not a number: " + optionValue);
                    UpdateTaskForceCLT.printHelp();
                    System.exit(0);
                }
            } else if (cmd.hasOption('n')) {
                schemaName = cmd.getOptionValue('n');
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                boolean noName;
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                boolean bl = noName = null == schemaName;
                if (noName && -1 == contextId) {
                    mbsc.invoke(Constants.OBJECT_NAME, "forceOnAllSchemas", new Object[]{className}, null);
                } else {
                    String param = noName ? String.valueOf(contextId) : schemaName;
                    mbsc.invoke(Constants.OBJECT_NAME, "force", new Object[]{className, param}, null);
                }
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            UpdateTaskForceCLT.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : (t instanceof OXException ? "Cannot find context " + contextId : t.getMessage());
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            UpdateTaskForceCLT.printHelp();
        }
    }

    static {
        toolkitOptions.addOption("h", "help", false, "Prints a help text");
        toolkitOptions.addOption("t", "task", true, "The update task's class name");
        StringBuilder sb = new StringBuilder(128);
        sb.append("A valid context identifier contained in target schema;");
        sb.append(" if missing and '-n/--name' option is also absent all schemas are considered.");
        toolkitOptions.addOption("c", "context", true, sb.toString());
        sb.setLength(0);
        sb.append("A valid schema name. This option is a substitute for '-c/--context' option.");
        sb.append(" If both are present '-c/--context' is preferred. If both absent all schemas are considered.");
        toolkitOptions.addOption("n", "name", true, sb.toString());
        toolkitOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        toolkitOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        toolkitOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

