/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.ContactsAddIndex4AutoCompleteSearch;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;

public class RemoveAdminPermissionOnInfostoreTask
extends UpdateTaskAdapter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RemoveAdminPermissionOnInfostoreTask.class));
    private static final String[] DEPENDENCIES = new String[]{ContactsAddIndex4AutoCompleteSearch.class.getName()};

    @Override
    public int addedWithVersion() {
        return 76;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Connection con;
        int triggeringContextId = params.getContextId();
        int[] ctxIds = Database.getContextsInSameSchema(triggeringContextId);
        ProgressState state = params.getProgressState();
        state.setTotal(ctxIds.length);
        StringBuilder sb = new StringBuilder(128);
        try {
            con = Database.getNoTimeout(triggeringContextId, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            con.setAutoCommit(false);
            for (int contextId : ctxIds) {
                try {
                    this.dropTopLevelInfostoreFolderPermissionFromAdmin(con, contextId);
                }
                catch (Exception e) {
                    sb.append("RemoveAdminPermissionOnInfostoreTask experienced an error while dropping ");
                    sb.append("incorrect admin permission on top level infostore folder in context ");
                    sb.append(contextId);
                    sb.append(":\n");
                    sb.append(e.getMessage());
                    LOG.error((Object)sb.toString(), (Throwable)e);
                    sb.setLength(0);
                }
                state.incrementState();
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(triggeringContextId, true, con);
        }
    }

    private void dropTopLevelInfostoreFolderPermissionFromAdmin(Connection con, int contextId) throws OXException, OXException {
        int mailAdmin = this.getMailAdmin(con, contextId);
        if (-1 == mailAdmin) {
            throw this.missingAdminError(contextId);
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, 9);
            stmt.setInt(3, mailAdmin);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private OXException missingAdminError(int contextId) {
        return ContextExceptionCodes.NO_MAILADMIN.create(Autoboxing.I((int)contextId));
    }

    private int getMailAdmin(Connection con, int contextId) throws OXException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DBUtils.closeSQLStuff(rs, stmt);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }
}

