/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountCreateTablesTask;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public final class MailAccountMigrationTask
extends UpdateTaskAdapter {
    private static final String[] DEPENDENCIES = new String[]{MailAccountCreateTablesTask.class.getName()};
    private static final FolderNameProvider DEFAULT_NAME_PROVIDER = new FolderNameProvider(){

        @Override
        public String getConfirmedHam() {
            return MailStrings.CONFIRMED_HAM;
        }

        @Override
        public String getConfirmedSpam() {
            return MailStrings.CONFIRMED_SPAM;
        }

        @Override
        public String getDrafts() {
            return MailStrings.DRAFTS;
        }

        @Override
        public String getSent() {
            return MailStrings.SENT;
        }

        @Override
        public String getSpam() {
            return MailStrings.SPAM;
        }

        @Override
        public String getTrash() {
            return MailStrings.TRASH;
        }
    };

    @Override
    public int addedWithVersion() {
        return 40;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Map<Integer, List<Integer>> m = MailAccountMigrationTask.getAllUsers(contextId);
        ProgressState state = params.getProgressState();
        state.setTotal(m.size());
        for (Map.Entry<Integer, List<Integer>> me : m.entrySet()) {
            int currentContextId = me.getKey();
            try {
                MailAccountMigrationTask.iterateUsersPerContext(me.getValue(), currentContextId);
            }
            catch (OXException e) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("MailAccountMigrationTask experienced an error while migrating mail accounts for users in context ");
                sb.append(currentContextId);
                sb.append(":\n");
                sb.append(e.getMessage());
                Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailAccountMigrationTask.class));
                LOG.error((Object)sb.toString(), (Throwable)e);
            }
            state.incrementState();
        }
    }

    private static Map<Integer, List<Integer>> getAllUsers(int contextId) throws OXException {
        HashMap<Integer, List<Integer>> hashMap;
        ResultSet rs;
        PreparedStatement stmt;
        Connection writeCon;
        block10: {
            try {
                writeCon = Database.get(contextId, true);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            stmt = null;
            rs = null;
            stmt = writeCon.prepareStatement("SELECT cid, id FROM user");
            rs = stmt.executeQuery();
            if (rs.next()) break block10;
            Map<Integer, List<Integer>> map = Collections.emptyMap();
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, true, writeCon);
            return map;
        }
        try {
            HashMap<Integer, List<Integer>> m = new HashMap<Integer, List<Integer>>();
            do {
                List<Integer> l;
                Integer cid = rs.getInt(1);
                Integer user = rs.getInt(2);
                if (!m.containsKey(cid)) {
                    l = new ArrayList();
                    m.put(cid, l);
                } else {
                    l = (List)m.get(cid);
                }
                l.add(user);
            } while (rs.next());
            hashMap = m;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, true, writeCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, true, writeCon);
        return hashMap;
    }

    private static boolean existsPrimaryMailAccount(int userId, int contextId) throws OXException {
        boolean bl;
        Connection writeCon;
        try {
            writeCon = Database.get(contextId, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = writeCon.prepareStatement("SELECT id FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, 0);
            stmt.setInt(3, userId);
            result = stmt.executeQuery();
            bl = result.next();
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(contextId, true, writeCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(contextId, true, writeCon);
        return bl;
    }

    private static void iterateUsersPerContext(List<Integer> users, int contextId) throws OXException {
        ContextImpl ctx = new ContextImpl(contextId);
        Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailAccountMigrationTask.class));
        MailAccountMigrationTask.checkAndInsertMailAccountSequence(ctx);
        try {
            StringBuilder sb = new StringBuilder(256);
            for (Integer userId : users) {
                if (MailAccountMigrationTask.existsPrimaryMailAccount(userId, contextId)) {
                    if (!LOG.isInfoEnabled()) continue;
                    sb.setLength(0);
                    LOG.info((Object)sb.append("Default mail account already exists for user ").append(userId).append(" in context ").append(ctx.getContextId()));
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    sb.setLength(0);
                    LOG.trace((Object)sb.append("Creating default mail account for user ").append(userId).append(" in context ").append(ctx.getContextId()));
                }
                User user = MailAccountMigrationTask.loadUser(ctx, userId);
                UserSettingMail usm = MailAccountMigrationTask.loadUserSettingMail(ctx, userId);
                try {
                    MailAccountMigrationTask.handleUser(user, MailAccountMigrationTask.getNameProvderFromUSM(usm), ctx, sb, LOG);
                }
                catch (OXException e) {
                    LOG.error((Object)("Default mail account for user " + user.getId() + " in context " + contextId + " could not be created"), (Throwable)e);
                }
            }
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static User loadUser(Context ctx, int userId) throws OXException, OXException {
        Connection con;
        try {
            con = Database.get(ctx, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            RdbUserStorage userStorage = new RdbUserStorage();
            User user = ((UserStorage)userStorage).getUser(ctx, userId, con);
            return user;
        }
        finally {
            Database.back(ctx, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserSettingMail loadUserSettingMail(Context ctx, int userId) throws OXException {
        Connection con;
        try {
            con = Database.get(ctx, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            UserSettingMail userSettingMail = UserSettingMailStorage.getInstance().getUserSettingMail(userId, ctx, con);
            return userSettingMail;
        }
        finally {
            Database.back(ctx, true, con);
        }
    }

    private static void handleUser(User user, FolderNameProvider folderNameProvdider, Context ctx, StringBuilder sb, Log LOG) throws OXException, OXException {
        MailAccountDescription account = MailAccountMigrationTask.createAccountDescription(user, folderNameProvdider);
        MailAccountMigrationTask.insertDefaultMailAccount(account, user.getId(), ctx);
        if (LOG.isInfoEnabled()) {
            sb.setLength(0);
            LOG.info((Object)sb.append("Created default mail account for user ").append(user.getId()).append(" in context ").append(ctx.getContextId()));
        }
    }

    private static MailAccountDescription createAccountDescription(User user, FolderNameProvider folderNameProvdider) throws OXException {
        MailAccountDescription account = new MailAccountDescription();
        account.setDefaultFlag(true);
        account.setConfirmedHam(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getConfirmedHam()));
        account.setConfirmedSpam(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getConfirmedSpam()));
        account.setDrafts(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getDrafts()));
        account.setId(0);
        account.setLogin(MailAccountMigrationTask.prepareNonNullString(user.getImapLogin()));
        account.parseMailServerURL(MailAccountMigrationTask.prepareNonNullString(user.getImapServer()));
        account.setName("E-Mail");
        account.setPassword(null);
        account.setPrimaryAddress(MailAccountMigrationTask.prepareNonNullString(user.getMail()));
        account.setSent(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getSent()));
        account.setSpam(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getSpam()));
        account.setSpamHandler("NoSpamHandler");
        account.parseTransportServerURL(MailAccountMigrationTask.prepareNonNullString(user.getSmtpServer()));
        account.setTrash(MailAccountMigrationTask.prepareNonNullString(folderNameProvdider.getTrash()));
        return account;
    }

    private static String prepareNonNullString(String string) {
        return null == string ? "" : string;
    }

    private static FolderNameProvider getNameProvderFromUSM(final UserSettingMail usm) {
        if (null == usm) {
            return DEFAULT_NAME_PROVIDER;
        }
        return new FolderNameProvider(){

            @Override
            public String getConfirmedHam() {
                return usm.getConfirmedHam();
            }

            @Override
            public String getConfirmedSpam() {
                return usm.getConfirmedSpam();
            }

            @Override
            public String getDrafts() {
                return usm.getStdDraftsName();
            }

            @Override
            public String getSent() {
                return usm.getStdSentName();
            }

            @Override
            public String getSpam() {
                return usm.getStdSpamName();
            }

            @Override
            public String getTrash() {
                return usm.getStdTrashName();
            }
        };
    }

    private static void insertDefaultMailAccount(MailAccountDescription mailAccount, int user, Context ctx) throws OXException {
        int cid = ctx.getContextId();
        boolean id = false;
        Connection con = null;
        try {
            con = Database.get(cid, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO user_mail_account (cid, id, user, name, url, login, password, primary_addr, default_flag, trash, sent, drafts, spam, confirmed_spam, confirmed_ham, spam_handler, trash_fullname, sent_fullname, drafts_fullname, spam_fullname, confirmed_spam_fullname, confirmed_ham_fullname) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int pos = 1;
            stmt.setLong(pos++, cid);
            stmt.setLong(pos++, 0L);
            stmt.setLong(pos++, user);
            stmt.setString(pos++, mailAccount.getName());
            stmt.setString(pos++, mailAccount.generateMailServerURL());
            stmt.setString(pos++, mailAccount.getLogin());
            stmt.setNull(pos++, 12);
            stmt.setString(pos++, mailAccount.getPrimaryAddress());
            stmt.setInt(pos++, 1);
            stmt.setString(pos++, mailAccount.getTrash());
            stmt.setString(pos++, mailAccount.getSent());
            stmt.setString(pos++, mailAccount.getDrafts());
            stmt.setString(pos++, mailAccount.getSpam());
            stmt.setString(pos++, mailAccount.getConfirmedSpam());
            stmt.setString(pos++, mailAccount.getConfirmedHam());
            String sh = mailAccount.getSpamHandler();
            if (null == sh) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, sh);
            }
            stmt.setString(pos++, "");
            stmt.setString(pos++, "");
            stmt.setString(pos++, "");
            stmt.setString(pos++, "");
            stmt.setString(pos++, "");
            stmt.setString(pos++, "");
            stmt.executeUpdate();
            stmt.close();
            stmt = con.prepareStatement("INSERT INTO user_transport_account (cid, id, user, name, url, login, password, send_addr, default_flag) VALUES (?,?,?,?,?,?,?,?,?)");
            pos = 1;
            stmt.setLong(pos++, cid);
            stmt.setLong(pos++, 0L);
            stmt.setLong(pos++, user);
            stmt.setString(pos++, mailAccount.getName());
            stmt.setString(pos++, mailAccount.generateTransportServerURL());
            stmt.setString(pos++, mailAccount.getLogin());
            stmt.setNull(pos++, 12);
            stmt.setString(pos++, mailAccount.getPrimaryAddress());
            stmt.setInt(pos++, 1);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            Database.back(cid, true, con);
        }
    }

    private static void checkAndInsertMailAccountSequence(Context ctx) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int cid;
        block5: {
            cid = ctx.getContextId();
            con = Database.get(cid, true);
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT * FROM sequence_mail_service WHERE cid = ?");
            stmt.setLong(1, cid);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(cid, true, con);
            return;
        }
        try {
            rs.close();
            stmt.close();
            stmt = con.prepareStatement("INSERT INTO sequence_mail_service (cid, id) VALUES (?, ?)");
            stmt.setLong(1, cid);
            stmt.setLong(2, 0L);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(cid, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(cid, true, con);
    }

    private static interface FolderNameProvider {
        public String getTrash();

        public String getSent();

        public String getDrafts();

        public String getSpam();

        public String getConfirmedSpam();

        public String getConfirmedHam();
    }
}

