/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IDCreateTableTask
extends UpdateTaskAdapter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(IDCreateTableTask.class));
    private static final String[] types = new String[]{"TABLE"};

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    private static final String getCreate() {
        return "CREATE TABLE sequenceIds (cid INT4 UNSIGNED NOT NULL,type VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,id INT4 UNSIGNED NOT NULL,PRIMARY KEY (cid, type)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        IDCreateTableTask.createTable("sequenceIds", IDCreateTableTask.getCreate(), params.getContextId());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"UpdateTask 'IDCreateTableTask' successfully performed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection writeCon;
        block5: {
            writeCon = Database.get(contextId, true);
            stmt = null;
            if (!IDCreateTableTask.tableExists(tablename, writeCon.getMetaData())) break block5;
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            return;
        }
        try {
            try {
                stmt = writeCon.prepareStatement(sqlCreate);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw IDCreateTableTask.createSQLError(e);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        Database.back(contextId, true, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(String tableName, DatabaseMetaData dbmd) throws SQLException {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = dbmd.getTables(null, null, tableName, types);
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, null);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, null);
        return bl;
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

