/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.ContactCollectOnIncomingAndOutgoingMailUpdateTask;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public final class GlobalAddressBookPermissionsResolverTask
extends UpdateTaskAdapter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GlobalAddressBookPermissionsResolverTask.class));
    private static final String[] DEPENDENCIES = new String[]{ContactCollectOnIncomingAndOutgoingMailUpdateTask.class.getName()};
    private static final String SQL_GET_CONTEXT_MAILADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";

    @Override
    public int addedWithVersion() {
        return 94;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        ProgressState status = params.getProgressState();
        Map<Integer, List<Integer>> m = GlobalAddressBookPermissionsResolverTask.getAllUsers(params.getContextId());
        status.setTotal(m.size());
        for (Map.Entry<Integer, List<Integer>> me : m.entrySet()) {
            int currentContextId = me.getKey();
            try {
                GlobalAddressBookPermissionsResolverTask.iterateUsersPerContext(me.getValue(), currentContextId);
            }
            catch (OXException e) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("GlobalAddressBookPermissionsResolverTask experienced an error while resolving to individual permissions for users in context ");
                sb.append(currentContextId);
                sb.append(":\n");
                sb.append(e.getMessage());
                LOG.error((Object)sb.toString(), (Throwable)e);
            }
            status.incrementState();
        }
    }

    private static Map<Integer, List<Integer>> getAllUsers(int contextId) throws OXException {
        HashMap<Integer, List<Integer>> hashMap;
        ResultSet rs;
        PreparedStatement stmt;
        Connection readCon;
        block10: {
            try {
                readCon = Database.getNoTimeout(contextId, false);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            stmt = null;
            rs = null;
            stmt = readCon.prepareStatement("SELECT cid, id FROM user");
            rs = stmt.executeQuery();
            if (rs.next()) break block10;
            Map<Integer, List<Integer>> map = Collections.emptyMap();
            DBUtils.closeSQLStuff(rs, stmt);
            Database.backNoTimeout(contextId, false, readCon);
            return map;
        }
        try {
            HashMap<Integer, List<Integer>> m = new HashMap<Integer, List<Integer>>();
            do {
                List<Integer> l;
                Integer cid = rs.getInt(1);
                Integer user = rs.getInt(2);
                if (!m.containsKey(cid)) {
                    l = new ArrayList();
                    m.put(cid, l);
                } else {
                    l = (List)m.get(cid);
                }
                l.add(user);
            } while (rs.next());
            hashMap = m;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.backNoTimeout(contextId, false, readCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.backNoTimeout(contextId, false, readCon);
        return hashMap;
    }

    private static void iterateUsersPerContext(List<Integer> users, int contextId) throws OXException {
        Connection writeCon;
        try {
            writeCon = Database.get(contextId, true);
            writeCon.setAutoCommit(false);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        try {
            GlobalAddressBookPermissionsResolverTask.checkGABPermissions4Users(users, contextId, writeCon);
            writeCon.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(writeCon);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(writeCon);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(writeCon);
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(writeCon);
            Database.back(contextId, true, writeCon);
        }
    }

    private static void checkGABPermissions4Users(List<Integer> users, int contextId, Connection writeCon) throws OXException {
        boolean found = false;
        HashSet<Integer> detectedUsers = new HashSet<Integer>();
        int[] permissions = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement("SELECT permission_id, fp, orp, owp, odp FROM oxfolder_permissions WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, 6);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int permissionId = rs.getInt(1);
                if (0 == permissionId) {
                    found = true;
                    permissions = new int[]{rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5)};
                    continue;
                }
                detectedUsers.add(permissionId);
            }
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            if (found) {
                stmt = writeCon.prepareStatement("DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, 6);
                stmt.setInt(3, 0);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        rs = null;
        stmt = null;
        GlobalAddressBookPermissionsResolverTask.checkMissingUserPermissions(users, detectedUsers, permissions, contextId, writeCon);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Global Address Book permission resolved for context " + contextId));
        }
    }

    private static void checkMissingUserPermissions(List<Integer> users, Set<Integer> detectedUsers, int[] permissions, int contextId, Connection writeCon) throws OXException {
        if (detectedUsers.size() < users.size()) {
            int adminUserId;
            int[] permissions2Insert = null == permissions ? GlobalAddressBookPermissionsResolverTask.getConfiguredPermissions() : permissions;
            try {
                adminUserId = GlobalAddressBookPermissionsResolverTask.getContextMailAdmin(writeCon, contextId);
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            PreparedStatement stmt = null;
            try {
                stmt = writeCon.prepareStatement("INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                for (Integer userId : users) {
                    if (detectedUsers.contains(userId)) continue;
                    int user = userId;
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos++, 6);
                    stmt.setInt(pos++, user);
                    stmt.setInt(pos++, permissions2Insert[0]);
                    stmt.setInt(pos++, permissions2Insert[1]);
                    stmt.setInt(pos++, permissions2Insert[2]);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, user == adminUserId ? 1 : 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
            }
        }
    }

    private static int[] getConfiguredPermissions() {
        if (OXFolderProperties.isEnableInternalUsersEdit()) {
            return new int[]{2, 4, 2, 0};
        }
        return new int[]{2, 4, 0, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getContextMailAdmin(Connection con, int cid) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            int n;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(SQL_GET_CONTEXT_MAILADMIN);
                stmt.setInt(1, cid);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return n;
        }
        int n = -1;
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }
}

