/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.groupware.update.ChangeColumnTypeUpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AllowTextInValuesOfDynamicContextAttributesTask
extends ChangeColumnTypeUpdateTask {
    public AllowTextInValuesOfDynamicContextAttributesTask() {
        super(null, "contextAttribute", "value", "TEXT");
    }

    @Override
    protected Column modifyColumn(Column c) {
        return new Column("value", "TEXT collate utf8_unicode_ci NOT NULL");
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.contexts.impl.sql.ContextAttributeTableUpdateTask"};
    }

    @Override
    public int addedWithVersion() {
        return -1;
    }

    @Override
    public int getPriority() {
        return SortableId.Priority.NORMAL.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void before(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DROP INDEX cid ON contextAttribute");
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    @Override
    public DatabaseService getDatabaseService() {
        return ServerServiceRegistry.getInstance().getService(DatabaseService.class);
    }
}

