/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.Schema;

public abstract class SchemaImpl
implements Schema {
    private static final long serialVersionUID = 8722328691217424068L;
    private boolean locked;
    private int dbVersion = -1;
    private boolean groupwareCompatible;
    private boolean adminCompatible;
    private String server;
    private String schema;

    protected SchemaImpl() {
    }

    public SchemaImpl(boolean locked, int dbVersion, boolean groupwareCompatible, boolean adminCompatible) {
        this.locked = locked;
        this.dbVersion = dbVersion;
        this.groupwareCompatible = groupwareCompatible;
        this.adminCompatible = adminCompatible;
    }

    public SchemaImpl(Schema schema) {
        this.locked = schema.isLocked();
        this.dbVersion = schema.getDBVersion();
        this.groupwareCompatible = schema.isGroupwareCompatible();
        this.adminCompatible = schema.isAdminCompatible();
        this.server = schema.getServer();
        this.schema = schema.getSchema();
    }

    @Override
    public int getDBVersion() {
        return this.dbVersion;
    }

    public void setDBVersion(int dbVersion) {
        this.dbVersion = dbVersion;
    }

    @Override
    public boolean isAdminCompatible() {
        return this.adminCompatible;
    }

    public void setAdminCompatible(boolean adminCompatible) {
        this.adminCompatible = adminCompatible;
    }

    @Override
    public boolean isGroupwareCompatible() {
        return this.groupwareCompatible;
    }

    public void setGroupwareCompatible(boolean groupwareCompatible) {
        this.groupwareCompatible = groupwareCompatible;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    void setBlockingUpdatesRunning(boolean locked) {
        this.locked = locked;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

