/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import com.openexchange.groupware.update.internal.UpdateTaskList;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DynamicList
implements UpdateTaskList<UpdateTask> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DynamicList.class));
    private static final DynamicList SINGLETON = new DynamicList();
    private final ConcurrentMap<Class<? extends UpdateTask>, UpdateTask> taskList = new ConcurrentHashMap<Class<? extends UpdateTask>, UpdateTask>();

    public static DynamicList getInstance() {
        return SINGLETON;
    }

    private DynamicList() {
    }

    public boolean addUpdateTask(UpdateTask updateTask) {
        boolean added;
        boolean bl = added = null == this.taskList.putIfAbsent(updateTask.getClass(), updateTask);
        if (added) {
            UpdateTaskCollection.getInstance().dirtyVersion();
        } else {
            LOG.error((Object)("Update task \"" + updateTask.getClass().getName() + "\" is already registered."));
        }
        return added;
    }

    public void removeUpdateTask(UpdateTask updateTask) {
        UpdateTask removed = (UpdateTask)this.taskList.remove(updateTask.getClass());
        if (null == removed) {
            LOG.error((Object)("Update task \"" + updateTask.getClass().getName() + "\" is unknown and could not be deregistered."));
        } else {
            UpdateTaskCollection.getInstance().dirtyVersion();
        }
    }

    @Override
    public List<UpdateTask> getTaskList() {
        ArrayList<UpdateTask> retval = new ArrayList<UpdateTask>(this.taskList.size());
        retval.addAll(this.taskList.values());
        return retval;
    }
}

