/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskSearch;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import java.sql.Connection;
import java.util.Date;
import java.util.Set;

public class TasksDelete
implements DeleteListener {
    private static final FolderStorage foldStor = FolderStorage.getInstance();
    private static final ParticipantStorage partStor = ParticipantStorage.getInstance();

    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        switch (event.getType()) {
            case 1: {
                this.deleteUser(event, writeCon);
                break;
            }
            case 2: {
                this.deleteGroup(event, readCon, writeCon);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
    }

    private void deleteUser(DeleteEvent event, Connection con) throws OXException {
        try {
            this.removeUserFromParticipants(event, con);
            this.assignToAdmin(event, con);
            this.changeCFMB(event, con);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private void removeUserFromParticipants(DeleteEvent event, Connection con) throws OXException {
        Context ctx = event.getContext();
        int userId = event.getId();
        for (StorageType type : StorageType.values()) {
            int[] tasks2;
            for (int task : tasks2 = partStor.findTasksWithParticipant(ctx, con, userId, type)) {
                partStor.deleteInternal(ctx, con, task, userId, type, true);
            }
        }
    }

    private void assignToAdmin(DeleteEvent event, Connection con) throws OXException {
        Session session = event.getSession();
        Context ctx = event.getContext();
        int userId = event.getId();
        for (StorageType type : StorageType.TYPES_AD) {
            int[][] result;
            for (int[] folderAndTask : result = foldStor.searchFolderByUser(ctx, con, userId, type)) {
                int folderId = folderAndTask[0];
                FolderObject folder = null;
                try {
                    folder = Tools.getFolder(ctx, con, folderId);
                }
                catch (OXException e) {
                    // empty catch block
                }
                int taskId = folderAndTask[1];
                Set<Folder> folders2 = foldStor.selectFolder(ctx, con, taskId, type);
                if (folders2.size() == 0) {
                    String folderName = null == folder ? "unknown" : folder.getFolderName();
                    throw TaskExceptionCode.NO_PERMISSION.create(Autoboxing.I((int)taskId), folderName, Autoboxing.I((int)folderId));
                }
                if (folders2.size() > 1) {
                    foldStor.deleteFolder(ctx, con, taskId, folderId, type);
                    continue;
                }
                if (ctx.getMailadmin() == userId || StorageType.DELETED == type || null == folder) {
                    TaskLogic.removeTask(session, ctx, con, folderId, taskId, type);
                    continue;
                }
                if (Tools.isFolderPublic(folder)) {
                    foldStor.deleteFolder(ctx, con, taskId, folderId, type);
                    Folder aFolder = new Folder(folderId, ctx.getMailadmin());
                    foldStor.insertFolder(ctx, con, taskId, aFolder, type);
                    continue;
                }
                if (Tools.isFolderPrivate(folder)) {
                    TaskLogic.removeTask(session, ctx, con, folderId, taskId, type);
                    continue;
                }
                throw TaskExceptionCode.UNIMPLEMENTED.create();
            }
        }
    }

    private void changeCFMB(DeleteEvent event, Connection con) throws OXException {
        int[] modified = new int[]{2, 3, 5};
        Context ctx = event.getContext();
        int userId = event.getId();
        TaskStorage stor = TaskStorage.getInstance();
        for (StorageType type : StorageType.TYPES_AD) {
            int[] tasks2;
            for (int taskId : tasks2 = TaskSearch.getInstance().findUserTasks(ctx, con, userId, type)) {
                Task update = stor.selectTask(ctx, con, taskId, type);
                Date lastModified = update.getLastModified();
                if (update.getCreatedBy() == userId) {
                    update.setCreatedBy(ctx.getMailadmin());
                }
                if (update.getModifiedBy() == userId) {
                    update.setModifiedBy(ctx.getMailadmin());
                }
                update.setLastModified(new Date());
                stor.updateTask(ctx, con, update, lastModified, modified, type);
            }
        }
    }

    private void deleteGroup(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        Context ctx = event.getContext();
        int groupId = event.getId();
        ParticipantStorage partStor = ParticipantStorage.getInstance();
        try {
            for (StorageType type : StorageType.values()) {
                int[] tasks2;
                for (int task : tasks2 = partStor.findTasksWithGroup(ctx, readCon, groupId, type)) {
                    Set<InternalParticipant> participants = partStor.selectInternal(ctx, readCon, task, type);
                    participants = TaskLogic.extractWithGroup(participants, groupId);
                    this.removeGroup(participants);
                    partStor.updateInternal(ctx, writeCon, task, participants, type);
                }
            }
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private void removeGroup(Set<InternalParticipant> participants) {
        for (InternalParticipant participant : participants) {
            participant.setGroupId(null);
        }
    }
}

