/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;

public class SendAddress
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "sendaddress"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    setting.setSingleValue(settings.getSendAddr());
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                String newAlias = setting.getSingleValue().toString();
                boolean found = false;
                String[] aliases = user.getAliases();
                if (null != aliases) {
                    for (int i = 0; !found && i < aliases.length; ++i) {
                        found = aliases[i].equals(newAlias);
                    }
                }
                if (user.getMail().equals(newAlias)) {
                    found = true;
                }
                if (!found) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(newAlias, setting.getName());
                }
                UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
                UserSettingMail settings = storage.getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    settings.setSendAddr(newAlias);
                    storage.saveUserSettingMail(settings, user.getId(), ctx);
                }
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

