/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.services.I18nServices;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class AvailableTimeZones
implements PreferencesItemService {
    private static final String NAME = "availableTimeZones";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                JSONObject json = new JSONObject();
                I18nServices i18nServices = I18nServices.getInstance();
                for (String timeZoneID : TimeZone.getAvailableIDs()) {
                    try {
                        json.put(timeZoneID, (Object)i18nServices.translate(user.getLocale(), timeZoneID.replace('_', ' '), false));
                    }
                    catch (JSONException e) {
                        OXException e1 = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                        throw new OXException(e1);
                    }
                }
                setting.setSingleValue(json);
            }
        };
    }
}

