/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.ReminderStorage;
import com.openexchange.groupware.reminder.internal.TargetRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class DeleteReminder {
    private static final ReminderStorage STORAGE = ReminderStorage.getInstance();
    private final Context ctx;
    private final ReminderObject reminder;

    public DeleteReminder(Context ctx, ReminderObject reminder) {
        this.ctx = ctx;
        this.reminder = reminder;
    }

    public void perform() throws OXException {
        Connection con = Database.get(this.ctx, true);
        try {
            con.setAutoCommit(false);
            this.delete(con);
            con.commit();
        }
        catch (SQLException e) {
            throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(this.ctx, true, con);
        }
    }

    private void delete(Connection con) throws OXException {
        try {
            STORAGE.deleteReminder(con, this.ctx.getContextId(), this.reminder.getObjectId());
            TargetRegistry.getInstance().getService(this.reminder.getModule()).updateTargetObject(this.ctx, con, this.reminder.getTargetId(), this.reminder.getUser());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }
}

