/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.internal.RdbReminderStorage;
import java.sql.Connection;
import java.util.Date;

public abstract class ReminderStorage {
    private static final ReminderStorage SINGLETON = new RdbReminderStorage();

    protected ReminderStorage() {
    }

    public static ReminderStorage getInstance() {
        return SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderObject[] selectReminder(Context ctx, User user, Date end) throws OXException {
        Connection con = Database.get(ctx, false);
        try {
            ReminderObject[] reminderObjectArray = this.selectReminder(ctx, con, user, end);
            return reminderObjectArray;
        }
        finally {
            Database.back(ctx, false, con);
        }
    }

    public abstract ReminderObject[] selectReminder(Context var1, Connection var2, User var3, Date var4) throws OXException;

    public abstract ReminderObject[] selectReminder(Context var1, Connection var2, int var3, Date var4) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReminder(Context ctx, ReminderObject reminder) throws OXException {
        Connection con = Database.get(ctx, true);
        try {
            this.deleteReminder(con, ctx.getContextId(), reminder.getObjectId());
        }
        finally {
            Database.back(ctx, true, con);
        }
    }

    public abstract void deleteReminder(Connection var1, int var2, int var3) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReminder(Context ctx, ReminderObject reminder) throws OXException {
        Connection con = Database.get(ctx, true);
        try {
            this.writeReminder(con, ctx.getContextId(), reminder);
        }
        finally {
            Database.back(ctx, true, con);
        }
    }

    public abstract void writeReminder(Connection var1, int var2, ReminderObject var3) throws OXException;
}

