/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.api2.ReminderService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.ReminderSearchIterator;
import com.openexchange.groupware.reminder.internal.GetArisingReminder;
import com.openexchange.groupware.reminder.internal.RemindAgain;
import com.openexchange.groupware.reminder.internal.TargetRegistry;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.logging.Log;

public class ReminderHandler
implements ReminderService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReminderHandler.class));
    final Context context;

    public ReminderHandler(Context context) {
        this.context = context;
    }

    @Override
    public int insertReminder(ReminderObject reminderObj) throws OXException {
        Connection writeCon = null;
        try {
            writeCon = DBPool.pickupWriteable(this.context);
            writeCon.setAutoCommit(false);
            int objectId = this.insertReminder(reminderObj, writeCon);
            writeCon.commit();
            int n = objectId;
            return n;
        }
        catch (SQLException exc) {
            DBUtils.rollback(writeCon);
            throw ReminderExceptionCode.INSERT_EXCEPTION.create(exc, new Object[0]);
        }
        finally {
            if (writeCon != null) {
                try {
                    writeCon.setAutoCommit(true);
                }
                catch (SQLException exc) {
                    LOG.warn((Object)"cannot set autocommit to true on connection", (Throwable)exc);
                }
            }
            DBPool.closeWriterSilent(this.context, writeCon);
        }
    }

    @Override
    public int insertReminder(ReminderObject reminderObj, Connection writeCon) throws OXException {
        if (reminderObj.getUser() == 0) {
            throw ReminderExceptionCode.MANDATORY_FIELD_USER.create("missing user id");
        }
        if (0 == reminderObj.getTargetId()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_TARGET_ID.create("missing target id");
        }
        if (reminderObj.getDate() == null) {
            throw ReminderExceptionCode.MANDATORY_FIELD_ALARM.create("missing alarm");
        }
        Statement ps = null;
        try {
            int a = 0;
            int objectId = IDGenerator.getId(this.context, 55, writeCon);
            reminderObj.setObjectId(objectId);
            ps = writeCon.prepareStatement("INSERT INTO reminder (object_id,cid,target_id,module,userid,alarm,recurrence,last_modified,folder) VALUES (?,?,?,?,?,?,?,?,?)");
            ps.setInt(++a, reminderObj.getObjectId());
            ps.setLong(++a, this.context.getContextId());
            ps.setInt(++a, reminderObj.getTargetId());
            ps.setInt(++a, reminderObj.getModule());
            ps.setInt(++a, reminderObj.getUser());
            ps.setTimestamp(++a, new Timestamp(reminderObj.getDate().getTime()));
            ps.setBoolean(++a, reminderObj.isRecurrenceAppointment());
            ps.setLong(++a, System.currentTimeMillis());
            ps.setInt(++a, reminderObj.getFolder());
            ps.executeUpdate();
            int n = objectId;
            return n;
        }
        catch (SQLException exc) {
            throw ReminderExceptionCode.INSERT_EXCEPTION.create(exc, new Object[0]);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException exc) {
                    LOG.warn((Object)"cannot close prepared statement", (Throwable)exc);
                }
            }
        }
    }

    @Override
    public void updateReminder(ReminderObject reminder) throws OXException {
        Connection con = DBPool.pickupWriteable(this.context);
        try {
            con.setAutoCommit(false);
            this.updateReminder(reminder, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ReminderExceptionCode.UPDATE_EXCEPTION.create(e, new Object[0]);
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.warn((Object)"cannot set autocommit to true on connection", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.context, con);
        }
    }

    @Override
    public void updateReminder(ReminderObject reminder, Connection con) throws OXException {
        this.isValid(reminder);
        boolean containsId = 0 != reminder.getObjectId();
        PreparedStatement stmt = null;
        try {
            stmt = containsId ? con.prepareStatement("UPDATE reminder SET alarm=?,recurrence=?,description=?,last_modified=?,folder=? WHERE cid=? AND object_id=?") : con.prepareStatement("UPDATE reminder SET alarm=?,recurrence=?,description=?,last_modified=?,folder=? WHERE cid=? AND target_id=? AND module=? AND userid=?");
            int pos = 1;
            stmt.setTimestamp(pos++, new Timestamp(reminder.getDate().getTime()));
            stmt.setBoolean(pos++, reminder.isRecurrenceAppointment());
            String description = reminder.getDescription();
            if (description == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, description);
            }
            stmt.setLong(pos++, System.currentTimeMillis());
            stmt.setInt(pos++, reminder.getFolder());
            stmt.setInt(pos++, this.context.getContextId());
            if (containsId) {
                stmt.setInt(pos++, reminder.getObjectId());
            } else {
                stmt.setString(pos++, String.valueOf(reminder.getTargetId()));
                stmt.setInt(pos++, reminder.getModule());
                stmt.setInt(pos++, reminder.getUser());
            }
            int updateCount = stmt.executeUpdate();
            if (updateCount > 1) {
                throw ReminderExceptionCode.TOO_MANY.create();
            }
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    public void isValid(ReminderObject reminder) throws OXException {
        if (0 == reminder.getUser()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_USER.create();
        }
        if (0 == reminder.getModule()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_MODULE.create();
        }
        if (0 == reminder.getFolder()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_FOLDER.create();
        }
        if (0 == reminder.getTargetId()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_TARGET_ID.create();
        }
        if (null == reminder.getDate()) {
            throw ReminderExceptionCode.MANDATORY_FIELD_ALARM.create();
        }
    }

    @Override
    public void deleteReminder(ReminderObject reminder) throws OXException {
        int contextId = this.context.getContextId();
        Connection writeCon = null;
        Statement ps = null;
        try {
            writeCon = DBPool.pickupWriteable(this.context);
            int a = 0;
            ps = writeCon.prepareStatement("DELETE FROM reminder WHERE cid=? AND object_id=?");
            ps.setInt(++a, contextId);
            ps.setInt(++a, reminder.getObjectId());
            int deleted = ps.executeUpdate();
            if (deleted == 0) {
                throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)reminder.getObjectId()), Autoboxing.I((int)contextId));
            }
            TargetRegistry.getInstance().getService(reminder.getModule()).updateTargetObject(this.context, writeCon, reminder.getTargetId(), reminder.getUser());
        }
        catch (SQLException exc) {
            throw ReminderExceptionCode.DELETE_EXCEPTION.create(exc, new Object[0]);
        }
        catch (NumberFormatException e) {
            throw ReminderExceptionCode.MANDATORY_FIELD_TARGET_ID.create("can't parse number.");
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException exc) {
                    LOG.warn((Object)"cannot close prepared statement", (Throwable)exc);
                }
            }
            if (writeCon != null) {
                try {
                    writeCon.setAutoCommit(true);
                }
                catch (SQLException exc) {
                    LOG.warn((Object)"cannot set autocommit to true on connection", (Throwable)exc);
                }
            }
            DBPool.closeWriterSilent(this.context, writeCon);
        }
    }

    @Override
    public void deleteReminder(int targetId, int userId, int module) throws OXException {
        Connection writeCon = DBPool.pickupWriteable(this.context);
        try {
            writeCon.setAutoCommit(false);
            this.deleteReminder(targetId, userId, module, writeCon);
            writeCon.commit();
        }
        catch (SQLException exc) {
            DBUtils.rollback(writeCon);
            throw ReminderExceptionCode.DELETE_EXCEPTION.create(exc, new Object[0]);
        }
        finally {
            DBUtils.autocommit(writeCon);
            DBPool.closeWriterSilent(this.context, writeCon);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteReminder(int targetId, int userId, int module, Connection con) throws OXException {
        int contextId = this.context.getContextId();
        if (userId == 0) {
            throw ReminderExceptionCode.MANDATORY_FIELD_USER.create("missing user id");
        }
        PreparedStatement stmt = null;
        try {
            int pos = 1;
            stmt = con.prepareStatement("DELETE FROM reminder WHERE cid=? AND target_id=? AND module=? AND userid=?");
            stmt.setInt(pos++, contextId);
            stmt.setString(pos++, String.valueOf(targetId));
            stmt.setInt(pos++, module);
            stmt.setInt(pos++, userId);
            if (0 == stmt.executeUpdate()) {
                throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)targetId), Autoboxing.I((int)contextId));
            }
            TargetRegistry.getInstance().getService(module).updateTargetObject(this.context, con, targetId, userId);
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.DELETE_EXCEPTION.create(e, new Object[0]);
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    @Override
    public void deleteReminder(int targetId, int module) throws OXException {
        Connection con = DBPool.pickupWriteable(this.context);
        try {
            con.setAutoCommit(false);
            this.deleteReminder(targetId, module, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(this.context, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteReminder(int targetId, int module, Connection con) throws OXException {
        int contextId = this.context.getContextId();
        PreparedStatement stmt = null;
        try {
            int pos = 1;
            stmt = con.prepareStatement("DELETE FROM reminder WHERE cid=? AND target_id=? AND module=?");
            stmt.setInt(pos++, contextId);
            stmt.setString(pos++, String.valueOf(targetId));
            stmt.setInt(pos++, module);
            if (0 == stmt.executeUpdate()) {
                throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)targetId), Autoboxing.I((int)contextId));
            }
            TargetRegistry.getInstance().getService(module).updateTargetObject(this.context, con, targetId);
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (OXException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    @Override
    public boolean existsReminder(int targetId, int userId, int module, Connection con) throws OXException {
        try {
            if (con == null) {
                this.loadReminder(targetId, userId, module);
            } else {
                this.loadReminder(targetId, userId, module, con);
            }
            return true;
        }
        catch (OXException exc) {
            if (ReminderExceptionCode.NOT_FOUND.equals(exc)) {
                return false;
            }
            throw exc;
        }
    }

    @Override
    public boolean existsReminder(int targetId, int userId, int module) throws OXException {
        return this.existsReminder(targetId, userId, module, null);
    }

    @Override
    public ReminderObject loadReminder(int targetId, int userId, int module) throws OXException {
        return this.loadReminder(String.valueOf(targetId), userId, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderObject loadReminder(String targetId, int userId, int module) throws OXException {
        Connection readCon = DBPool.pickup(this.context);
        try {
            ReminderObject reminderObject = this.loadReminder(targetId, userId, module, readCon);
            return reminderObject;
        }
        finally {
            DBPool.closeReaderSilent(this.context, readCon);
        }
    }

    @Override
    public ReminderObject loadReminder(int targetId, int userId, int module, Connection readCon) throws OXException {
        if (readCon == null) {
            return this.loadReminder(String.valueOf(targetId), userId, module);
        }
        return this.loadReminder(String.valueOf(targetId), userId, module, readCon);
    }

    public ReminderObject loadReminder(String targetId, int userId, int module, Connection con) throws OXException {
        ReminderObject reminderObject;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int pos = 1;
            stmt = con.prepareStatement("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND target_id=? AND module=? AND userid=?");
            stmt.setInt(pos++, this.context.getContextId());
            stmt.setString(pos++, targetId);
            stmt.setInt(pos++, module);
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            reminderObject = ReminderHandler.result2Object(this.context, result, stmt, false);
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.LOAD_EXCEPTION.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return reminderObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReminderObject[] loadReminder(int[] targetIds, int userId, int module) throws OXException {
        Connection con = DBPool.pickup(this.context);
        try {
            ReminderObject[] reminderObjectArray = this.loadReminder(targetIds, userId, module, con);
            return reminderObjectArray;
        }
        finally {
            DBPool.closeReaderSilent(this.context, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReminderObject[] loadReminders(int[] targetIds, int userId, int module, Connection connection) throws OXException {
        Connection con = null;
        boolean externalConnection = false;
        if (connection == null) {
            con = DBPool.pickup(this.context);
        } else {
            con = connection;
            externalConnection = true;
        }
        try {
            ReminderObject[] reminderObjectArray = this.loadReminder(targetIds, userId, module, con);
            return reminderObjectArray;
        }
        finally {
            if (!externalConnection) {
                DBPool.closeReaderSilent(this.context, con);
            }
        }
    }

    private ReminderObject[] loadReminder(int[] targetIds, int userId, int module, Connection con) throws OXException {
        ReminderObject[] reminderObjectArray;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(DBUtils.getIN("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND module=? AND userid=? AND target_id IN (", targetIds.length));
            int pos = 1;
            stmt.setInt(pos++, this.context.getContextId());
            stmt.setInt(pos++, module);
            stmt.setInt(pos++, userId);
            for (int targetId : targetIds) {
                stmt.setString(pos++, String.valueOf(targetId));
            }
            result = stmt.executeQuery();
            reminderObjectArray = this.result2Object(result);
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.LOAD_EXCEPTION.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return reminderObjectArray;
    }

    private ReminderObject[] result2Object(ResultSet result) throws SQLException {
        LinkedList<ReminderObject> retval = new LinkedList<ReminderObject>();
        while (result.next()) {
            int pos = 1;
            try {
                ReminderObject reminder = new ReminderObject();
                reminder.setObjectId(result.getInt(pos++));
                reminder.setTargetId(result.getInt(pos++));
                reminder.setModule(result.getInt(pos++));
                reminder.setUser(result.getInt(pos++));
                reminder.setDate(result.getTimestamp(pos++));
                reminder.setRecurrenceAppointment(result.getBoolean(pos++));
                reminder.setDescription(result.getString(pos++));
                reminder.setFolder(result.getInt(pos++));
                reminder.setLastModified(new Date(result.getLong(pos++)));
                retval.add(reminder);
            }
            catch (SQLException e) {
                LOG.error((Object)ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage()));
            }
        }
        return retval.toArray(new ReminderObject[retval.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReminderObject loadReminder(int objectId) throws OXException {
        Connection readCon = DBPool.pickup(this.context);
        try {
            ReminderObject reminderObject = this.loadReminder(objectId, readCon);
            return reminderObject;
        }
        finally {
            DBPool.closeReaderSilent(this.context, readCon);
        }
    }

    public ReminderObject loadReminder(int objectId, Connection readCon) throws OXException {
        PreparedStatement ps;
        int contextId;
        block5: {
            contextId = this.context.getContextId();
            ps = null;
            int a = 0;
            ps = readCon.prepareStatement("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND object_id=?");
            ps.setInt(++a, contextId);
            ps.setInt(++a, objectId);
            ResultSet rs = ps.executeQuery();
            ReminderObject reminderObj = ReminderHandler.result2Object(this.context, rs, ps, true);
            if (reminderObj == null) break block5;
            ReminderObject reminderObject = reminderObj;
            DBUtils.closeSQLStuff(ps);
            return reminderObject;
        }
        try {
            try {
                throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)objectId), Autoboxing.I((int)contextId));
            }
            catch (SQLException exc) {
                throw ReminderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(ps);
            throw throwable;
        }
    }

    public static ReminderObject result2Object(Context ctx, ResultSet result, PreparedStatement stmt, boolean closeStatements) throws SQLException, OXException {
        try {
            if (result.next()) {
                int pos = 1;
                ReminderObject reminderObj = new ReminderObject();
                reminderObj.setObjectId(result.getInt(pos++));
                reminderObj.setTargetId(result.getInt(pos++));
                reminderObj.setModule(result.getInt(pos++));
                reminderObj.setUser(result.getInt(pos++));
                reminderObj.setDate(result.getTimestamp(pos++));
                reminderObj.setRecurrenceAppointment(result.getBoolean(pos++));
                reminderObj.setDescription(result.getString(pos++));
                reminderObj.setFolder(result.getInt(pos++));
                reminderObj.setLastModified(new Date(result.getLong(pos++)));
                ReminderObject reminderObject = reminderObj;
                return reminderObject;
            }
            throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        finally {
            if (closeStatements) {
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
    }

    public SearchIterator<ReminderObject> listReminder(int module, int targetId) throws OXException {
        Connection con = DBPool.pickup(this.context);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND module=? AND target_id=?");
            int pos = 1;
            ps.setInt(pos++, this.context.getContextId());
            ps.setInt(pos++, module);
            ps.setString(pos++, String.valueOf(targetId));
            rs = ps.executeQuery();
            return new ReminderSearchIterator(this.context, ps, rs, con);
        }
        catch (SQLException e) {
            DBUtils.closeSQLStuff(rs, ps);
            DBPool.closeReaderSilent(this.context, con);
            throw ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (SearchIteratorException e) {
            DBUtils.closeSQLStuff(rs, ps);
            DBPool.closeReaderSilent(this.context, con);
            throw new OXException((OXException)((Object)e));
        }
    }

    @Override
    public SearchIterator<ReminderObject> getArisingReminder(Session session, Context ctx, User user, Date end) throws OXException {
        GetArisingReminder arising = new GetArisingReminder(session, ctx, user, end);
        return arising.loadWithIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remindAgain(ReminderObject reminder, Session session, Context ctx) throws OXException {
        Connection readCon = null;
        try {
            readCon = DBPool.pickupWriteable(this.context);
            this.remindAgain(reminder, session, ctx, readCon);
        }
        finally {
            DBPool.closeWriterSilent(this.context, readCon);
        }
    }

    @Override
    public void remindAgain(ReminderObject reminder, Session session, Context ctx, Connection writeCon) throws OXException {
        RemindAgain remindAgain = new RemindAgain(reminder, session, ctx, this);
        remindAgain.remindAgain();
        try {
            TargetRegistry.getInstance().getService(reminder.getModule()).updateTargetObject(this.context, writeCon, reminder.getTargetId());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    public SearchIterator<ReminderObject> listModifiedReminder(int userId, Date lastModified) throws OXException {
        Connection readCon = DBPool.pickup(this.context);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = readCon.prepareStatement("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND userid=? AND last_modified>?");
            ps.setInt(1, this.context.getContextId());
            ps.setInt(2, userId);
            ps.setTimestamp(3, new Timestamp(lastModified.getTime()));
            rs = ps.executeQuery();
            return new ReminderSearchIterator(this.context, ps, rs, readCon);
        }
        catch (SearchIteratorException exc) {
            DBUtils.closeSQLStuff(rs, ps);
            DBPool.closeReaderSilent(this.context, readCon);
            throw new OXException((OXException)((Object)exc));
        }
        catch (SQLException exc) {
            DBUtils.closeSQLStuff(rs, ps);
            DBPool.closeReaderSilent(this.context, readCon);
            throw ReminderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
        }
    }
}

