/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ReminderExceptionCode implements OXExceptionCode
{
    MANDATORY_FIELD_USER("User is missing for the reminder.", 1, CATEGORY_ERROR),
    MANDATORY_FIELD_TARGET_ID("Object identifier is missing.", 2, CATEGORY_ERROR),
    MANDATORY_FIELD_ALARM("Alarm date for the reminder is missing.", 3, CATEGORY_ERROR),
    INSERT_EXCEPTION("Unable to insert reminder", 4, CATEGORY_ERROR),
    UPDATE_EXCEPTION("Unable to update reminder", 5, CATEGORY_ERROR),
    DELETE_EXCEPTION("Unable to delete reminder", 6, CATEGORY_ERROR),
    LOAD_EXCEPTION("Unable to load reminder", 7, CATEGORY_ERROR),
    LIST_EXCEPTION("Unable to list reminder", 8, CATEGORY_ERROR),
    NOT_FOUND("Reminder with identifier %1$d can not be found in context %2$d.", 9, CATEGORY_ERROR),
    MANDATORY_FIELD_FOLDER("Object folder is missing", 10, CATEGORY_ERROR),
    MANDATORY_FIELD_MODULE("Object's module type is missing", 11, CATEGORY_ERROR),
    TOO_MANY("Updated too many reminders.", 12, CATEGORY_ERROR),
    SQL_ERROR("SQL Problem: \"%1$s\"", 13, CATEGORY_ERROR),
    NO_TARGET_SERVICE("No target service is registered for module %1$d.", 14, CATEGORY_ERROR),
    UNEXPECTED_ERROR("Unexpected error: %1$s", 15, CATEGORY_ERROR),
    MANDATORY_FIELD_ID("Reminder identifier is missing.", 16, CATEGORY_ERROR);

    private final String message;
    private final Category category;
    private final int detailNumber;

    private ReminderExceptionCode(String message, int detailNumber, Category category) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public String getPrefix() {
        return "REM";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

