/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.caching.CacheService;
import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;

class UserFactory
implements OXObjectFactory<User> {
    private final UserStorage delegate;
    private final CacheService cacheService;
    private final Lock lock;
    private final Context ctx;
    private final int userId;

    public UserFactory(UserStorage delegate, CacheService cacheService, Lock lock, Context ctx, int userId) {
        this.delegate = delegate;
        this.cacheService = cacheService;
        this.lock = lock;
        this.ctx = ctx;
        this.userId = userId;
    }

    public Serializable getKey() {
        return this.cacheService.newCacheKey(this.ctx.getContextId(), this.userId);
    }

    public User load() throws OXException, OXException {
        return this.delegate.getUser(this.userId, this.ctx);
    }

    public Lock getCacheLock() {
        return this.lock;
    }
}

