/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockExpiryListener;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class LockManagerImpl<T extends Lock>
extends DBService
implements LockManager {
    private static final String PAT_TABLENAME = "%%tablename%%";
    private String INSERT = "INSERT INTO %%tablename%% (entity, timeout, scope, type, ownerDesc, cid, userid, id %%additional_fields%% ) VALUES (?, ?, ?, ?, ?, ?, ?, ? %%additional_question_marks%%)";
    private String DELETE = "DELETE FROM %%tablename%% WHERE cid = ? AND id = ? ";
    private String REASSIGN = "UPDATE %%tablename%% SET userid = ? WHERE userid = ? and cid = ?";
    private String FIND_BY_ENTITY = "SELECT entity, timeout, scope, type, ownerDesc, cid, userid, id %%additional_fields%% FROM %%tablename%% WHERE entity IN %%entity_ids%% and cid = ? ";
    private String EXISTS_BY_ENTITY = "SELECT 1 FROM %%tablename%% WHERE entity IN %%entity_ids%% and cid = ? ";
    private String DELETE_BY_ENTITY = "DELETE FROM %%tablename%% WHERE cid = ? AND entity = ?";
    private String UPDATE_BY_ID = "UPDATE %%tablename%% SET timeout = ? , scope = ?, type = ? , ownerDesc = ? %%additional_updates%% WHERE id = ? AND cid = ?";
    private final List<LockExpiryListener> expiryListeners = new ArrayList<LockExpiryListener>();

    public LockManagerImpl(String tablename) {
        this(null, tablename);
    }

    public LockManagerImpl(DBProvider provider, String tablename) {
        this.setProvider(provider);
        this.initTablename(tablename);
    }

    private void initTablename(String tablename) {
        this.INSERT = this.INSERT.replaceAll(PAT_TABLENAME, tablename);
        this.INSERT = this.initAdditionalINSERT(this.INSERT);
        this.DELETE = this.DELETE.replaceAll(PAT_TABLENAME, tablename);
        this.FIND_BY_ENTITY = this.FIND_BY_ENTITY.replaceAll(PAT_TABLENAME, tablename);
        this.FIND_BY_ENTITY = this.initAdditionalFIND_BY_ENTITY(this.FIND_BY_ENTITY);
        this.EXISTS_BY_ENTITY = this.EXISTS_BY_ENTITY.replaceAll(PAT_TABLENAME, tablename);
        this.DELETE_BY_ENTITY = this.DELETE_BY_ENTITY.replaceAll(PAT_TABLENAME, tablename);
        this.UPDATE_BY_ID = this.UPDATE_BY_ID.replaceAll(PAT_TABLENAME, tablename);
        this.UPDATE_BY_ID = this.initAdditionalUPDATE_BY_ID(this.UPDATE_BY_ID);
        this.REASSIGN = this.REASSIGN.replaceAll(PAT_TABLENAME, tablename);
    }

    private String initAdditionalUPDATE_BY_ID(String query) {
        return query.replaceAll("%%additional_updates%%", "");
    }

    protected String initAdditionalINSERT(String insert) {
        return insert.replaceAll("%%additional_fields%%", "").replaceAll("%%additional_question_marks%%", "");
    }

    protected String initAdditionalFIND_BY_ENTITY(String findByEntity) {
        return findByEntity.replaceAll("%%additional_fields%%", "");
    }

    protected int getType() {
        return 139;
    }

    protected abstract T newLock();

    protected void fillLock(T lock, ResultSet rs) throws SQLException {
        ((Lock)lock).setId(rs.getInt("id"));
        ((Lock)lock).setOwner(rs.getInt("userid"));
        int scopeNum = rs.getInt("scope");
        for (LockManager.Scope scope : LockManager.Scope.values()) {
            if (scopeNum != scope.ordinal()) continue;
            ((Lock)lock).setScope(scope);
        }
        ((Lock)lock).setType(LockManager.Type.WRITE);
        long timeout = rs.getLong("timeout") - System.currentTimeMillis();
        ((Lock)lock).setTimeout(timeout);
        ((Lock)lock).setOwnerDescription(rs.getString("ownerDesc"));
        ((Lock)lock).setEntity(rs.getInt("entity"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int createLockForceId(int entity, int id, long timeout, LockManager.Scope scope, LockManager.Type type, String ownerDesc, Context ctx, User user, Object ... additional) throws OXException {
        int n;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getWriteConnection(ctx);
            stmt = con.prepareStatement(this.INSERT);
            long tm = 0L;
            if (timeout != -1L) {
                tm = System.currentTimeMillis() + timeout;
                if (tm < 0L) {
                    tm = Long.MAX_VALUE;
                }
            } else {
                tm = Long.MAX_VALUE;
            }
            this.set(1, stmt, additional, entity, tm, scope.ordinal(), type.ordinal(), ownerDesc, ctx.getContextId(), user.getId(), id);
            stmt.executeUpdate();
            n = id;
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, con);
        return n;
    }

    protected int createLock(int entity, long timeout, LockManager.Scope scope, LockManager.Type type, String ownerDesc, Context ctx, User user, Object ... additional) throws OXException {
        try {
            return this.createLockForceId(entity, IDGenerator.getId(ctx, this.getType()), timeout, scope, type, ownerDesc, ctx, user, additional);
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.NEW_ID_FAILED.create(e, new Object[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLock(int lockId, long timeout, LockManager.Scope scope, LockManager.Type type, String ownerDesc, Context ctx, Object ... additional) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getWriteConnection(ctx);
            stmt = con.prepareStatement(this.UPDATE_BY_ID);
            long tm = 0L;
            tm = timeout != -1L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            int index = this.set(1, stmt, additional, tm, scope.ordinal(), type.ordinal(), ownerDesc);
            this.set(index, stmt, null, lockId, ctx.getContextId());
            stmt.executeUpdate();
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeLock(int id, Context ctx) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getWriteConnection(ctx);
            stmt = con.prepareStatement(this.DELETE);
            this.set(1, stmt, null, ctx.getContextId(), id);
            stmt.executeUpdate();
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, List<T>> findLocksByEntity(List<Integer> entities, Context ctx) throws OXException {
        HashMap<Integer, List<T>> hashMap;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder entityIds = new StringBuilder().append('(');
            entityIds.append(this.join(entities));
            entityIds.append(')');
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(this.FIND_BY_ENTITY.replaceAll("%%entity_ids%%", entityIds.toString()));
            this.set(1, stmt, null, ctx.getContextId());
            rs = stmt.executeQuery();
            HashMap<Integer, List<T>> locks = new HashMap<Integer, List<T>>();
            HashSet<Integer> entitySet = new HashSet<Integer>(entities);
            while (rs.next()) {
                int entity = rs.getInt("entity");
                entitySet.remove(entity);
                ArrayList<T> lockList = (ArrayList<T>)locks.get(entity);
                if (null == lockList) {
                    lockList = new ArrayList<T>();
                    locks.put(entity, lockList);
                }
                T lock = this.newLock();
                this.fillLock(lock, rs);
                if (((Lock)lock).getTimeout() < 1L) {
                    this.removeLock(((Lock)lock).getId(), ctx);
                    this.lockExpired((Lock)lock);
                    continue;
                }
                lockList.add(lock);
            }
            for (Integer entity : entitySet) {
                locks.put(entity, new ArrayList());
            }
            hashMap = locks;
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseReadConnection(ctx, con);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsLockForEntity(List<Integer> entities, Context ctx) throws OXException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder entityIds = new StringBuilder().append('(');
            entityIds.append(this.join(entities));
            entityIds.append(')');
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(this.EXISTS_BY_ENTITY.replaceAll("%%entity_ids%%", entityIds.toString()));
            this.set(1, stmt, null, ctx.getContextId());
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseReadConnection(ctx, con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reassign(Context ctx, int from, int to) throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.prepareStatement(this.REASSIGN);
            stmt.setInt(1, to);
            stmt.setInt(2, from);
            stmt.setInt(3, ctx.getContextId());
            stmt.executeUpdate();
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, writeCon);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeAllFromEntity(int entity, Context ctx) throws OXException {
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = this.getWriteConnection(ctx);
            stmt = writeCon.prepareStatement(this.DELETE_BY_ENTITY);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            stmt.executeUpdate();
        }
        catch (SQLException x) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt));
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, writeCon);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, writeCon);
    }

    protected CharSequence join(List<Integer> entities) {
        StringBuilder b = new StringBuilder();
        for (int entity : entities) {
            b.append(entity);
            b.append(", ");
        }
        b.setLength(b.length() - 2);
        return b;
    }

    protected final int set(int index, PreparedStatement stmt, Object[] additional, Object ... values) throws SQLException {
        for (Object o : values) {
            stmt.setObject(index++, o);
        }
        if (null == additional) {
            return index;
        }
        for (Object o : additional) {
            stmt.setObject(index++, o);
        }
        return index;
    }

    public void addExpiryListener(LockExpiryListener listener) {
        this.expiryListeners.add(listener);
    }

    protected void lockExpired(Lock lock) throws OXException {
        for (LockExpiryListener listener : this.expiryListeners) {
            listener.lockExpired(lock);
        }
    }
}

