/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.internal.FolderStorageDeleteListener;
import com.openexchange.folderstorage.outlook.OutlookFolderDeleteListener;
import com.openexchange.groupware.attach.impl.AttachmentContextDelete;
import com.openexchange.groupware.attach.impl.AttachmentDelDelete;
import com.openexchange.groupware.calendar.CalendarAdministrationService;
import com.openexchange.groupware.contact.ContactDeleteListener;
import com.openexchange.groupware.delete.CacheClearerOnContextDelete;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.delete.POP3DeleteListener;
import com.openexchange.groupware.delete.SessionClearerOnContextDelete;
import com.openexchange.groupware.filestore.FileStorageRemover;
import com.openexchange.groupware.infostore.InfostoreDelete;
import com.openexchange.groupware.tasks.TasksDelete;
import com.openexchange.groupware.userconfiguration.UserConfigurationDeleteListener;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.mail.usersetting.UserSettingMailDeleteListener;
import com.openexchange.mailaccount.internal.MailAccountDeleteListener;
import com.openexchange.preferences.UserSettingServerDeleteListener;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.sessiond.impl.SessionDeleteListener;
import com.openexchange.tools.file.QuotaUsageDelete;
import com.openexchange.tools.oxfolder.OXFolderDeleteListener;
import java.sql.Connection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DeleteRegistry {
    private static final Object PRESENT = new Object();
    private static volatile DeleteRegistry instance;
    private final ConcurrentMap<Class<? extends DeleteListener>, Object> classes = new ConcurrentHashMap<Class<? extends DeleteListener>, Object>();
    private final List<DeleteListener> staticListeners;
    private final Queue<DeleteListener> listeners;

    static void initInstance() {
        instance = new DeleteRegistry();
    }

    static void releaseInstance() {
        instance.dispose();
        instance = null;
    }

    public static DeleteRegistry getInstance() {
        return instance;
    }

    private DeleteRegistry() {
        DeleteListener[] tmpListeners;
        for (DeleteListener deleteListener : tmpListeners = this.getStaticListeners()) {
            this.classes.put(deleteListener.getClass(), PRESENT);
        }
        this.staticListeners = new CopyOnWriteArrayList<DeleteListener>(tmpListeners);
        this.listeners = new Java7ConcurrentLinkedQueue();
    }

    private void dispose() {
        this.staticListeners.clear();
        this.classes.clear();
        this.listeners.clear();
    }

    private DeleteListener[] getStaticListeners() {
        return new DeleteListener[]{new SessionDeleteListener(), new TasksDelete(), new InfostoreDelete(), new ContactDeleteListener(), ServerServiceRegistry.getInstance().getService(CalendarAdministrationService.class), new UserConfigurationDeleteListener(), new UserSettingMailDeleteListener(), new QuotaUsageDelete(), new AttachmentContextDelete(), new AttachmentDelDelete(), new CacheClearerOnContextDelete(), new SessionClearerOnContextDelete(), new FolderStorageDeleteListener(), new OXFolderDeleteListener(), new FileStorageRemover(), new OutlookFolderDeleteListener(), new UserSettingServerDeleteListener(), new POP3DeleteListener(), new MailAccountDeleteListener()};
    }

    public boolean registerDeleteListener(DeleteListener listener) {
        if (null != this.classes.putIfAbsent(listener.getClass(), PRESENT)) {
            return false;
        }
        return this.listeners.offer(listener);
    }

    public void unregisterDeleteListener(DeleteListener listener) {
        if (null == this.classes.remove(listener.getClass())) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void fireDeleteEvent(DeleteEvent deleteEvent, Connection readCon, Connection writeCon) throws OXException {
        for (DeleteListener listener : this.listeners) {
            listener.deletePerformed(deleteEvent, readCon, writeCon);
        }
        for (DeleteListener listener : this.staticListeners) {
            listener.deletePerformed(deleteEvent, readCon, writeCon);
        }
    }
}

