/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.ContextDelete;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;

public final class CacheClearerOnContextDelete
extends ContextDelete {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (!this.isContextDelete(event)) {
            return;
        }
        org.apache.commons.logging.Log logger = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CacheClearerOnContextDelete.class));
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            logger.warn((Object)(CacheService.class.getSimpleName() + " is absent."));
            return;
        }
        List<String> cacheNames = Arrays.asList("USMOXObjectIDToUUIDCache", "USMUUIDToOXObjectIDCache", "USMUUIDCache");
        for (String cacheName : cacheNames) {
            try {
                Cache cache = cacheService.getCache(cacheName);
                cache.clear();
            }
            catch (OXException e) {
                logger.warn((Object)("Clearing cache \"" + cacheName + "\" failed."), (Throwable)e);
            }
        }
    }
}

