/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.datahandler;

import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.datahandler.ICalDataHandler;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;

public final class ICalInsertDataHandler
extends ICalDataHandler {
    private static final String[] ARGS = new String[]{"com.openexchange.groupware.calendar.folder", "com.openexchange.groupware.task.folder"};
    private static final Class<?>[] TYPES = new Class[]{InputStream.class};

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public Object processData(Data<? extends Object> data, DataArguments dataArguments, Session session) throws OXException {
        List<Task> tasks2;
        List<CalendarDataObject> appointments;
        long size;
        Context ctx;
        int taskFolder;
        int calendarFolder;
        try {
            calendarFolder = Integer.parseInt(dataArguments.get(ARGS[0]));
        }
        catch (NumberFormatException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create(new Object[]{ARGS[0], e, dataArguments.get(ARGS[0])});
        }
        OXException missingTaskFolderException = null;
        try {
            taskFolder = Integer.parseInt(dataArguments.get(ARGS[1]));
        }
        catch (NumberFormatException e) {
            missingTaskFolderException = DataExceptionCodes.INVALID_ARGUMENT.create(new Object[]{ARGS[1], e, dataArguments.get(ARGS[1])});
            taskFolder = -1;
        }
        ICalDataHandler.Confirm confirm = this.parseConfirmation(dataArguments);
        try {
            ctx = ContextStorage.getStorageContext(session);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        ICalParser iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class);
        if (iCalParser == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ICalParser.class.getName()});
        }
        try {
            size = Long.parseLong(data.getDataProperties().get("com.openexchange.conversion.size"));
        }
        catch (NumberFormatException e) {
            size = 0L;
        }
        ICalDataHandler.InputStreamCopy inputStreamCopy = ICalInsertDataHandler.copyStream((InputStream)data.getData(), size);
        try {
            TimeZone defaultZone = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class).getTimeZone(UserStorage.getStorageUser(session.getUserId(), ctx).getTimeZone());
            ArrayList<ConversionError> conversionErrors = new ArrayList<ConversionError>(4);
            ArrayList<ConversionWarning> conversionWarnings = new ArrayList<ConversionWarning>(4);
            appointments = this.parseAppointmentStream(ctx, iCalParser, inputStreamCopy, conversionErrors, conversionWarnings, defaultZone);
            conversionErrors.clear();
            conversionWarnings.clear();
            tasks2 = this.parseTaskStream(ctx, iCalParser, inputStreamCopy, conversionErrors, conversionWarnings, defaultZone);
        }
        catch (ConversionError e) {
            throw new OXException((OXException)e);
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            inputStreamCopy.close();
        }
        JSONArray folderAndIdArray = new JSONArray();
        if (!appointments.isEmpty()) {
            try {
                this.insertAppointments(session, calendarFolder, ctx, appointments, confirm, folderAndIdArray);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            catch (JSONException e) {
                throw new OXException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]));
            }
        }
        if (!tasks2.isEmpty()) {
            if (taskFolder < 0) {
                if (null != missingTaskFolderException) {
                    throw missingTaskFolderException;
                }
                throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[1]});
            }
            try {
                this.insertTasks(session, taskFolder, tasks2, folderAndIdArray);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            catch (JSONException e) {
                throw new OXException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]));
            }
        }
        return folderAndIdArray;
    }

    private ICalDataHandler.Confirm parseConfirmation(DataArguments dataArguments) {
        int confirmStatus = -1;
        String confirmMessage = null;
        if (dataArguments.containsKey("com.openexchange.groupware.calendar.confirmstatus")) {
            confirmStatus = Integer.parseInt(dataArguments.get("com.openexchange.groupware.calendar.confirmstatus"));
            if (dataArguments.containsKey("com.openexchange.groupware.calendar.confirmmessage")) {
                confirmMessage = dataArguments.get("com.openexchange.groupware.calendar.confirmmessage");
            }
            return new ICalDataHandler.Confirm(confirmStatus, confirmMessage);
        }
        return null;
    }
}

