/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container.mail;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.server.impl.Version;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;

public class MailObject {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailObject.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final int DONT_SET = -2;
    private String fromAddr;
    private String[] toAddrs;
    private String[] ccAddrs;
    private String[] bccAddrs;
    private String subject;
    private Object text;
    private String contentType;
    private boolean requestReadReceipt;
    private final Session session;
    private final int objectId;
    private final int folderId;
    private final int module;
    private final String type;
    private Multipart multipart;
    private boolean internalRecipient = true;
    private String uid;
    private long recurrenceDatePosition;
    private static final String HEADER_XPRIORITY = "X-Priority";
    private static final String HEADER_DISPNOTTO = "Disposition-Notification-Toy";
    private static final String HEADER_XOXREMINDER = "X-OX-Reminder";
    private static final String VALUE_PRIORITYNROM = "3 (normal)";
    private static final String HEADER_ORGANIZATION = "Organization";
    private static final String HEADER_X_MAILER = "X-Mailer";
    private static final String HEADER_X_OX_MODULE = "X-Open-Xchange-Module";
    private static final String HEADER_X_OX_TYPE = "X-Open-Xchange-Type";
    private static final String HEADER_X_OX_OBJECT = "X-Open-Xchange-Object";
    private static final String HEADER_X_OX_UID = "X-Open-Xchange-UID";
    private static final String HEADER_X_OX_RECURRENCE_DATE = "X-Open-Xchange-RDATE";

    public MailObject(Session session, int objectId, int folderId, int module, String type) {
        this.session = session;
        this.objectId = objectId;
        this.folderId = folderId;
        this.module = module;
        this.type = type;
    }

    private final void validateMailObject() throws OXException {
        if (MailObject.isEmpty(this.fromAddr)) {
            throw MailExceptionCode.MISSING_FIELD.create("From");
        }
        if (this.toAddrs == null || this.toAddrs.length == 0) {
            throw MailExceptionCode.MISSING_FIELD.create("To");
        }
        if (MailObject.isEmpty(this.contentType)) {
            throw MailExceptionCode.MISSING_FIELD.create("Content-Type");
        }
        if (this.subject == null) {
            throw MailExceptionCode.MISSING_FIELD.create("Subject");
        }
        if (this.text == null) {
            throw MailExceptionCode.MISSING_FIELD.create("Text");
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public void setInternalRecipient(boolean internalRecipient) {
        this.internalRecipient = internalRecipient;
    }

    public void addFileAttachment(ContentType contentType, File file) throws OXException {
        String fileName = file.getName();
        ContentType ct = new ContentType();
        ct.setContentType(contentType);
        if (ct.startsWith("application/octet-stream")) {
            String ctStr = MimeType2ExtMap.getContentType(fileName);
            int pos = ctStr.indexOf(47);
            ct.setPrimaryType(ctStr.substring(0, pos));
            ct.setSubType(ctStr.substring(pos + 1));
        }
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file, ct.toString())));
            if (fileName != null && !ct.containsNameParameter()) {
                ct.setNameParameter(fileName);
            }
            bodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
            bodyPart.setHeader("Content-Transfer-Encoding", "base64");
            String disposition = bodyPart.getHeader("Content-Disposition", null);
            if (disposition == null) {
                String disp;
                if (fileName == null) {
                    disp = "attachment";
                } else {
                    ContentDisposition contentDisposition = new ContentDisposition("attachment");
                    contentDisposition.setFilenameParameter(fileName);
                    disp = MimeMessageUtility.foldContentDisposition(contentDisposition.toString());
                }
                bodyPart.setHeader("Content-Disposition", disp);
            } else {
                ContentDisposition contentDisposition = new ContentDisposition(disposition);
                contentDisposition.setDisposition("attachment");
                if (fileName != null && !contentDisposition.containsFilenameParameter()) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                bodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
            }
            if (this.multipart == null) {
                this.multipart = new MimeMultipart("mixed");
            }
            this.multipart.addBodyPart((BodyPart)bodyPart);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public void addFileAttachment(ContentType contentType, String fileName, InputStream inputStream) throws OXException {
        ContentType ct = new ContentType();
        ct.setContentType(contentType);
        if (ct.startsWith("application/octet-stream") && fileName != null) {
            String ctStr = MimeType2ExtMap.getContentType(fileName);
            int pos = ctStr.indexOf(47);
            ct.setPrimaryType(ctStr.substring(0, pos));
            ct.setSubType(ctStr.substring(pos + 1));
        }
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(inputStream, this.getContentType())));
            if (fileName != null && !ct.containsNameParameter()) {
                ct.setNameParameter(fileName);
            }
            bodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
            bodyPart.setHeader("Content-Transfer-Encoding", "base64");
            String disposition = bodyPart.getHeader("Content-Disposition", null);
            if (disposition == null) {
                String disp;
                if (fileName == null) {
                    disp = "attachment";
                } else {
                    ContentDisposition contentDisposition = new ContentDisposition("attachment");
                    contentDisposition.setFilenameParameter(fileName);
                    disp = MimeMessageUtility.foldContentDisposition(contentDisposition.toString());
                }
                bodyPart.setHeader("Content-Disposition", disp);
            } else {
                ContentDisposition contentDisposition = new ContentDisposition(disposition);
                contentDisposition.setDisposition("attachment");
                if (fileName != null && !contentDisposition.containsFilenameParameter()) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                bodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
            }
            if (this.multipart == null) {
                this.multipart = new MimeMultipart("mixed");
            }
            this.multipart.addBodyPart((BodyPart)bodyPart);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void send() throws OXException {
        try {
            ContentType ct;
            this.validateMailObject();
            MimeMessage msg = new MimeMessage(MimeDefaultSession.getDefaultSession());
            InternetAddress[] internetAddrs = MimeMessageUtility.parseAddressList(this.fromAddr, false);
            if (null == internetAddrs || 0 == internetAddrs.length) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)new AddressException("\"From\" cannot be parsed: " + this.fromAddr)));
            }
            msg.setFrom((Address)internetAddrs[0]);
            msg.setReplyTo((Address[])internetAddrs);
            String tmp = Arrays.toString(this.toAddrs);
            tmp = tmp.substring(1, tmp.length() - 1);
            internetAddrs = MimeMessageUtility.parseAddressList(tmp, false);
            msg.setRecipients(Message.RecipientType.TO, (Address[])internetAddrs);
            if (this.ccAddrs != null && this.ccAddrs.length > 0) {
                tmp = Arrays.toString(this.ccAddrs);
                tmp = tmp.substring(1, tmp.length() - 1);
                internetAddrs = MimeMessageUtility.parseAddressList(tmp, false);
                msg.setRecipients(Message.RecipientType.CC, (Address[])internetAddrs);
            }
            if (this.bccAddrs != null && this.bccAddrs.length > 0) {
                tmp = Arrays.toString(this.bccAddrs);
                tmp = tmp.substring(1, tmp.length() - 1);
                internetAddrs = MimeMessageUtility.parseAddressList(tmp, false);
                msg.setRecipients(Message.RecipientType.BCC, (Address[])internetAddrs);
            }
            if (!(ct = new ContentType(this.contentType)).containsCharsetParameter()) {
                ct.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            }
            msg.setSubject(this.subject, ct.getCharsetParameter());
            if (!"text".equalsIgnoreCase(ct.getPrimaryType())) {
                // empty if block
            }
            String subType = ct.getSubType();
            if (this.multipart == null) {
                if ("html".equalsIgnoreCase(subType) || "htm".equalsIgnoreCase(subType)) {
                    msg.setContent(this.text, ct.toString());
                } else if ("plain".equalsIgnoreCase(subType) || "enriched".equalsIgnoreCase(subType)) {
                    if (!ct.containsCharsetParameter()) {
                        msg.setText((String)this.text);
                    } else {
                        msg.setText((String)this.text, ct.getCharsetParameter());
                    }
                } else {
                    if (!ct.startsWith("multipart/")) throw MailExceptionCode.UNSUPPORTED_MIME_TYPE.create(ct.toString());
                    msg.setContent((Multipart)this.text);
                }
            } else {
                MimeBodyPart textPart = new MimeBodyPart();
                if ("html".equalsIgnoreCase(subType) || "htm".equalsIgnoreCase(subType)) {
                    textPart.setContent(this.text, ct.toString());
                } else if ("plain".equalsIgnoreCase(subType) || "enriched".equalsIgnoreCase(subType)) {
                    if (!ct.containsCharsetParameter()) {
                        textPart.setText((String)this.text);
                    } else {
                        textPart.setText((String)this.text, ct.getCharsetParameter());
                    }
                } else {
                    if (!ct.startsWith("multipart/")) throw MailExceptionCode.UNSUPPORTED_MIME_TYPE.create(ct.toString());
                    textPart.setContent((Multipart)this.text);
                }
                textPart.setHeader("MIME-Version", "1.0");
                textPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
                this.multipart.addBodyPart((BodyPart)textPart, 0);
                msg.setContent(this.multipart);
            }
            if (this.requestReadReceipt) {
                msg.setHeader(HEADER_DISPNOTTO, this.fromAddr);
            }
            msg.setHeader(HEADER_XPRIORITY, VALUE_PRIORITYNROM);
            msg.setHeader(HEADER_X_MAILER, "Open-Xchange Mailer v" + Version.getVersionString());
            try {
                String organization = ServerServiceRegistry.getInstance().getService(ContactService.class).getOrganization(this.session);
                if (null != organization && 0 < organization.length()) {
                    msg.setHeader(HEADER_ORGANIZATION, organization);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Header \"Organization\" could not be set", (Throwable)e);
            }
            if (this.internalRecipient && this.folderId != -2) {
                msg.setHeader(HEADER_XOXREMINDER, "" + this.objectId + ',' + this.folderId + ',' + this.module);
            }
            if (msg.getSentDate() == null) {
                MailDateFormat mdf;
                MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat(this.session);
                synchronized (mailDateFormat) {
                    msg.setHeader("Date", mdf.format(new Date()));
                }
            }
            if (this.internalRecipient) {
                msg.setHeader(HEADER_X_OX_MODULE, 1 == this.module ? "Appointments" : "Tasks");
            }
            if (this.internalRecipient && this.type != null) {
                msg.setHeader(HEADER_X_OX_TYPE, this.type);
            }
            if (this.internalRecipient) {
                msg.setHeader(HEADER_X_OX_OBJECT, Integer.toString(this.objectId));
            }
            if (this.internalRecipient && this.uid != null) {
                msg.setHeader(HEADER_X_OX_UID, this.uid);
            }
            if (this.internalRecipient && this.recurrenceDatePosition != 0L) {
                msg.setHeader(HEADER_X_OX_RECURRENCE_DATE, String.valueOf(this.recurrenceDatePosition));
            }
            msg.saveChanges();
            MailTransport transport = MailTransport.getInstance(this.session);
            try {
                UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream();
                msg.writeTo((OutputStream)bos);
                transport.sendRawMessage(bos.toByteArray());
                if (!DEBUG) return;
                LOG.debug((Object)("Sent mail:\n" + new String(bos.toByteArray())));
                return;
            }
            finally {
                transport.close();
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public void addBccAddr(String addr) {
        this.bccAddrs = MailObject.addAddr(addr, this.bccAddrs);
    }

    public String[] getBccAddrs() {
        return this.bccAddrs;
    }

    public void setBccAddrs(String[] bccAddrs) {
        this.bccAddrs = bccAddrs;
    }

    public void addCcAddr(String addr) {
        this.ccAddrs = MailObject.addAddr(addr, this.ccAddrs);
    }

    public String[] getCcAddrs() {
        return this.ccAddrs;
    }

    public void setCcAddrs(String[] ccAddrs) {
        this.ccAddrs = ccAddrs;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFromAddr() {
        return this.fromAddr;
    }

    public void setFromAddr(String fromAddr) {
        this.fromAddr = fromAddr;
    }

    public Object getText() {
        return this.text;
    }

    public void setText(Object text) {
        this.text = text;
    }

    public void addToAddr(String addr) {
        this.toAddrs = MailObject.addAddr(addr, this.toAddrs);
    }

    public String[] getToAddrs() {
        return this.toAddrs;
    }

    public void setToAddrs(String[] toAddrs) {
        this.toAddrs = toAddrs;
    }

    public boolean isRequestReadReceipt() {
        return this.requestReadReceipt;
    }

    public void setRequestReadReceipt(boolean requestReadReceipt) {
        this.requestReadReceipt = requestReadReceipt;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public void setRecurrenceDatePosition(long time) {
        this.recurrenceDatePosition = time;
    }

    public long getRecurrenceDatePosition() {
        return this.recurrenceDatePosition;
    }

    private static final String[] addAddr(String addr, String[] arr) {
        if (arr == null) {
            return new String[]{addr};
        }
        String[] tmp = arr;
        arr = new String[tmp.length + 1];
        System.arraycopy(tmp, 0, arr, 0, tmp.length);
        arr[arr.length - 1] = addr;
        return arr;
    }
}

