/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.AbstractContactSwitcherWithDelegate;
import com.openexchange.groupware.container.Contact;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class ContactSwitcherForSimpleDateFormat
extends AbstractContactSwitcherWithDelegate {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactSwitcherForSimpleDateFormat.class));
    private static final DateValidator DEFAULT_VALIDATOR = new DateValidator(){

        @Override
        public boolean isValid(String dateString) {
            return true;
        }
    };
    private final List<DateFormat> dateFormats = new LinkedList<DateFormat>();
    private final List<DateValidator> dateValidators = new LinkedList<DateValidator>();

    private static DateValidator getValidatorFor(DateFormat dateFormat) {
        String pattern = ContactSwitcherForSimpleDateFormat.getPatternFrom(dateFormat);
        if (null == pattern) {
            return DEFAULT_VALIDATOR;
        }
        try {
            String invalidRegex = pattern.replaceAll("[a-zA-Z]+", "0+");
            return new RegexDateValidator(Pattern.compile(invalidRegex));
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return DEFAULT_VALIDATOR;
        }
    }

    private static String getPatternFrom(DateFormat dateFormat) {
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return null;
        }
        return ((SimpleDateFormat)dateFormat).toPattern();
    }

    private Object[] makeDate(Object ... objects) throws OXException {
        if (objects[1] instanceof String) {
            String dateString = (String)objects[1];
            int size = this.dateFormats.size();
            for (int index = 0; index < size; ++index) {
                try {
                    objects[1] = this.dateFormats.get(index).parse(dateString);
                    if (!this.dateValidators.get(index).isValid(dateString)) {
                        objects[1] = null;
                        ((Contact)objects[0]).addWarning(ContactExceptionCodes.DATE_CONVERSION_FAILED.create(dateString));
                    }
                    return objects;
                }
                catch (ParseException e) {
                    LOG.debug((Object)e.getMessage());
                    continue;
                }
            }
            throw ContactExceptionCodes.DATE_CONVERSION_FAILED.create((String)objects[1]);
        }
        return objects;
    }

    public void addDateFormat(DateFormat dateFormat) {
        this.dateFormats.add(dateFormat);
        this.dateValidators.add(ContactSwitcherForSimpleDateFormat.getValidatorFor(dateFormat));
    }

    @Override
    public Object creationdate(Object ... objects) throws OXException {
        try {
            return this.delegate.creationdate(this.makeDate(objects));
        }
        catch (ClassCastException e) {
            throw ContactExceptionCodes.CONV_OBJ_2_DATE_FAILED.create(e, objects[1], "CreationDate");
        }
    }

    @Override
    public Object anniversary(Object ... objects) throws OXException {
        try {
            return this.delegate.anniversary(this.makeDate(objects));
        }
        catch (ClassCastException e) {
            throw ContactExceptionCodes.CONV_OBJ_2_DATE_FAILED.create(e, objects[1], "Anniversary");
        }
    }

    @Override
    public Object birthday(Object ... objects) throws OXException {
        try {
            return this.delegate.birthday(this.makeDate(objects));
        }
        catch (ClassCastException e) {
            throw ContactExceptionCodes.CONV_OBJ_2_DATE_FAILED.create(e, objects[1], "Birthday");
        }
    }

    @Override
    public Object imagelastmodified(Object ... objects) throws OXException {
        try {
            return this.delegate.imagelastmodified(this.makeDate(objects));
        }
        catch (ClassCastException e) {
            throw ContactExceptionCodes.CONV_OBJ_2_DATE_FAILED.create(e, objects[1], "ImageLastModified");
        }
    }

    @Override
    public Object lastmodified(Object ... objects) throws OXException {
        try {
            return this.delegate.lastmodified(this.makeDate(objects));
        }
        catch (ClassCastException e) {
            throw ContactExceptionCodes.CONV_OBJ_2_DATE_FAILED.create(e, objects[1], "LastModified");
        }
    }

    private static final class RegexDateValidator
    implements DateValidator {
        private final Pattern invalidPattern;

        public RegexDateValidator(Pattern pattern) {
            this.invalidPattern = pattern;
        }

        @Override
        public boolean isValid(String dateString) {
            return !this.invalidPattern.matcher(dateString).matches();
        }
    }

    private static interface DateValidator {
        public boolean isValid(String var1);
    }
}

