/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Differ;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class CalendarDataObject
extends Appointment {
    private static final long serialVersionUID = -1333032651882959872L;
    private String rec_string;
    private Context context;
    private int folder_type = -1;
    private int pfid;
    private int action_folder;
    private int shared_folder_owner;
    private int folder_move_action;
    private boolean is_hard_conflict;
    private boolean contains_resources;
    private boolean folder_move;
    private boolean b_recurrencestring;
    private boolean fill_participants;
    private boolean fill_user_participants;
    private boolean fill_folder_id;
    private boolean fillConfirmations;
    private boolean fillLastModifiedOfNewestAttachment;
    private boolean externalOrganizer;
    private static final String STR_DELIM = " - ";
    public static Set<Differ<? super CalendarDataObject>> differ = new HashSet<Differ<? super CalendarDataObject>>();

    private CalendarCollectionService getCalendarCollectionService() {
        return ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
    }

    @Override
    public final void setUntil(Date until) {
        if (until != null) {
            long mod = until.getTime() % 86400000L;
            if (mod != 0L) {
                if (this.getCalendarCollectionService().exceedsHourOfDay(until.getTime(), this.getTimezoneFallbackUTC())) {
                    until.setTime(until.getTime() - mod + 86400000L);
                } else {
                    until.setTime(until.getTime() - mod);
                }
            }
            super.setUntil(until);
        } else {
            super.setUntil(until);
        }
    }

    @Override
    public void setOccurrence(int occurrence) {
        if (occurrence == 0) {
            this.setUntil(null);
        }
        super.setOccurrence(occurrence);
    }

    public final void setSharedFolderOwner(int shared_folder_owner) {
        this.shared_folder_owner = shared_folder_owner;
    }

    public final int getSharedFolderOwner() {
        return this.shared_folder_owner;
    }

    public final void setFolderType(int folder_type) {
        this.folder_type = folder_type;
    }

    public final int getFolderType() {
        return this.folder_type;
    }

    public final void setActionFolder(int action_folder) {
        this.action_folder = action_folder;
    }

    public final int getActionFolder() {
        return this.action_folder;
    }

    public final void setGlobalFolderID(int fid) {
        super.setParentFolderID(fid);
    }

    public final int getGlobalFolderID() {
        return this.getParentFolderID();
    }

    public final void setPrivateFolderID(int pfid) {
        this.pfid = pfid;
    }

    public final int getPrivateFolderID() {
        return this.pfid;
    }

    public int getEffectiveFolderId() {
        if (this.getParentFolderID() != 0) {
            return this.getParentFolderID();
        }
        if (this.getPrivateFolderID() != 0) {
            return this.getPrivateFolderID();
        }
        if (this.getActionFolder() != 0) {
            return this.getActionFolder();
        }
        return 0;
    }

    public final void setContext(Context context) {
        this.context = context;
    }

    public final Context getContext() {
        return this.context;
    }

    public final int getContextID() {
        if (this.context != null) {
            return this.context.getContextId();
        }
        return 0;
    }

    public final void setRecurrence(String rec_string) {
        this.rec_string = rec_string;
        this.b_recurrencestring = true;
    }

    public final boolean containsRecurrenceString() {
        return this.b_recurrencestring;
    }

    public final String getRecurrence() {
        return this.rec_string;
    }

    public final void setDelExceptions(String delete_execptions) {
        if (delete_execptions != null) {
            super.setDeleteExceptions(this.getCalendarCollectionService().convertString2Dates(delete_execptions));
        } else {
            this.setDeleteExceptions((Date[])null);
        }
    }

    public final String getDelExceptions() {
        if (this.containsDeleteExceptions()) {
            return this.getCalendarCollectionService().convertDates2String(this.getDeleteException());
        }
        return null;
    }

    public final void setExceptions(String change_exceptions) {
        if (change_exceptions != null) {
            super.setChangeExceptions(this.getCalendarCollectionService().convertString2Dates(change_exceptions));
        } else {
            this.setChangeExceptions((Date[])null);
        }
    }

    public final String getExceptions() {
        if (this.containsChangeExceptions()) {
            return this.getCalendarCollectionService().convertDates2String(this.getChangeException());
        }
        return null;
    }

    public final boolean calculateRecurrence() throws OXException {
        if (this.isSequence()) {
            return this.getCalendarCollectionService().fillDAO(this);
        }
        return false;
    }

    @Override
    public final Date getUntil() {
        if (!this.containsUntil()) {
            return this.getCalendarCollectionService().getMaxUntilDate(this);
        }
        return super.getUntil();
    }

    public final boolean isSequence(boolean what) {
        if (what) {
            return this.containsRecurrenceString() && this.getRecurrence() != null || this.containsRecurrenceType() && this.getRecurrenceType() > 0 && this.getInterval() > 0;
        }
        return this.containsRecurrenceID() && this.containsRecurrenceType() && this.getRecurrenceType() > 0 && this.getInterval() > 0;
    }

    public final boolean isSequence() {
        return this.isSequence(true);
    }

    public void setFolderMove(boolean folder_move) {
        this.folder_move = folder_move;
    }

    public boolean getFolderMove() {
        return this.folder_move;
    }

    public void setFolderMoveAction(int folder_move_action) {
        this.folder_move_action = folder_move_action;
    }

    public int getFolderMoveAction() {
        return this.folder_move_action;
    }

    public void setContainsResources(boolean contains_resources) {
        this.contains_resources = contains_resources;
    }

    public boolean containsResources() {
        return this.contains_resources;
    }

    public boolean isHardConflict() {
        return this.is_hard_conflict;
    }

    public void setHardConflict() {
        this.is_hard_conflict = true;
    }

    public void setFillParticipants() {
        this.fill_participants = true;
    }

    public boolean fillParticipants() {
        return this.fill_participants;
    }

    public void setFillConfirmations() {
        this.fillConfirmations = true;
    }

    public boolean fillConfirmations() {
        return this.fillConfirmations;
    }

    public void setFillUserParticipants() {
        this.fill_user_participants = true;
    }

    public boolean fillUserParticipants() {
        return this.fill_user_participants;
    }

    public void setFillFolderID() {
        this.fill_folder_id = true;
    }

    public boolean fillFolderID() {
        return this.fill_folder_id;
    }

    public boolean isFillLastModifiedOfNewestAttachment() {
        return this.fillLastModifiedOfNewestAttachment;
    }

    public void setFillLastModifiedOfNewestAttachment(boolean fillLastModifiedOfNewestAttachment) {
        this.fillLastModifiedOfNewestAttachment = fillLastModifiedOfNewestAttachment;
    }

    @Override
    public CalendarDataObject clone() {
        CalendarDataObject clone = (CalendarDataObject)super.clone();
        clone.setContext(this.getContext());
        if (this.containsObjectID()) {
            clone.setObjectID(this.getObjectID());
        }
        if (this.containsTitle()) {
            clone.setTitle(this.getTitle());
        }
        if (this.containsLocation()) {
            clone.setLocation(this.getLocation());
        }
        if (this.containsStartDate()) {
            clone.setStartDate(this.getStartDate());
        }
        if (this.containsEndDate()) {
            clone.setEndDate(this.getEndDate());
        }
        if (this.containsCreatedBy()) {
            clone.setCreatedBy(this.getCreatedBy());
        }
        if (this.containsCreationDate()) {
            clone.setCreationDate((Date)this.getCreationDate().clone());
        }
        if (this.containsLastModified()) {
            clone.setLastModified(this.getLastModified());
        }
        if (this.containsModifiedBy()) {
            clone.setModifiedBy(this.getModifiedBy());
        }
        if (this.containsPrivateFlag()) {
            clone.setPrivateFlag(this.getPrivateFlag());
        }
        if (this.containsLabel()) {
            clone.setLabel(this.getLabel());
        }
        if (this.containsShownAs()) {
            clone.setShownAs(this.getShownAs());
        }
        if (this.containsNumberOfAttachments()) {
            clone.setNumberOfAttachments(this.getNumberOfAttachments());
        }
        if (this.containsNote()) {
            clone.setNote(this.getNote());
        }
        if (this.containsFullTime()) {
            clone.setFullTime(this.getFullTime());
        }
        if (this.containsCategories()) {
            clone.setCategories(this.getCategories());
        }
        if (this.containsRecurrenceID()) {
            clone.setRecurrenceID(this.getRecurrenceID());
        }
        if (this.containsRecurrencePosition()) {
            clone.setRecurrencePosition(this.getRecurrencePosition());
        }
        if (this.containsRecurrenceType()) {
            clone.setRecurrenceType(this.getRecurrenceType());
        }
        if (this.containsRecurringStart()) {
            clone.setRecurringStart(this.getRecurringStart());
        }
        if (this.containsInterval()) {
            clone.setInterval(this.getInterval());
        }
        if (this.containsMonth()) {
            clone.setMonth(this.getMonth());
        }
        if (this.containsDays()) {
            clone.setDays(this.getDays());
        }
        if (this.containsDayInMonth()) {
            clone.setDayInMonth(this.getDayInMonth());
        }
        if (this.containsUntil()) {
            clone.setUntil(this.getUntil());
        }
        if (this.containsOccurrence()) {
            clone.setOccurrence(this.getOccurrence());
        }
        if (this.containsChangeExceptions()) {
            clone.setChangeExceptions(CalendarDataObject.copy(this.getChangeException()));
        }
        if (this.containsDeleteExceptions()) {
            clone.setDeleteExceptions(CalendarDataObject.copy(this.getDeleteException()));
        }
        if (this.containsNotification()) {
            clone.setNotification(this.getNotification());
        }
        clone.setIgnoreConflicts(this.ignoreConflicts);
        clone.setRecurrenceCalculator(this.getRecurrenceCalculator());
        if (this.containsRecurrenceString()) {
            clone.setRecurrence(this.getRecurrence());
        }
        clone.setFolderType(this.getFolderType());
        clone.setTimezone(this.getTimezoneFallbackUTC());
        clone.setParentFolderID(this.getParentFolderID());
        clone.setPrivateFolderID(this.getPrivateFolderID());
        clone.setActionFolder(this.getActionFolder());
        clone.setFolderType(this.getFolderType());
        clone.setContainsResources(this.containsResources());
        if (this.isHardConflict()) {
            clone.setHardConflict();
        }
        clone.setFolderMoveAction(this.getFolderMoveAction());
        clone.setFolderMove(this.getFolderMove());
        clone.setSharedFolderOwner(this.getSharedFolderOwner());
        return clone;
    }

    public boolean isExternalOrganizer() {
        return this.externalOrganizer;
    }

    public void setExternalOrganizer(boolean externalOrganizer) {
        this.externalOrganizer = externalOrganizer;
    }

    private static final Date[] copy(Date[] copyMe) {
        if (copyMe == null) {
            return null;
        }
        Date[] clone = new Date[copyMe.length];
        for (int i = 0; i < clone.length; ++i) {
            Date cur = copyMe[i];
            clone[i] = (Date)(cur == null ? null : cur.clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append('@');
        sb.append('\n');
        sb.append("object_id - title - start - end : ");
        sb.append(this.getObjectID());
        sb.append(STR_DELIM);
        sb.append(this.getTitle());
        sb.append(STR_DELIM);
        sb.append(this.getStartDate());
        sb.append(STR_DELIM);
        sb.append(this.getEndDate());
        sb.append('\n');
        sb.append("context_id: ");
        sb.append(this.getContextID());
        sb.append('\n');
        sb.append("folder_information (parent:effective:action:type:move:move_action): ");
        sb.append(this.getParentFolderID());
        sb.append(':');
        sb.append(this.getEffectiveFolderId());
        sb.append(':');
        sb.append(this.getActionFolder());
        sb.append(':');
        sb.append(this.getFolderType());
        sb.append(':');
        sb.append(this.getFolderMove());
        sb.append(':');
        sb.append(this.getFolderMoveAction());
        sb.append(')');
        sb.append('\n');
        sb.append("recurrence: ");
        sb.append(this.getRecurrence());
        sb.append(" -- ");
        sb.append(this.getRecurrenceID());
        sb.append(STR_DELIM);
        sb.append(this.getRecurrenceType());
        sb.append(STR_DELIM);
        sb.append(this.getInterval());
        sb.append(STR_DELIM);
        sb.append(this.getDays());
        sb.append(STR_DELIM);
        sb.append(this.getMonth());
        sb.append(STR_DELIM);
        sb.append(this.getDayInMonth());
        return sb.toString();
    }

    static {
        differ.addAll(Appointment.differ);
    }
}

