/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.apache.commons.logging.Log;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="updates", description="Get updated attachments.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="attached", description="Object ID of the object to which the attachments are attached."), @Parameter(name="module", description="Module ID (as per Attachment object) of the attached object."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for attachments are defined in Common object data (with only id, created_by and creation_date available) and Attachment object."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified."), @Parameter(name="timestamp", description="Timestamp of the last update of the requested infoitems."), @Parameter(name="ignore", optional=true, description="Which kinds of updates should be ignored. Currently, the only valid value \u2013 \"deleted\" \u2013 causes deleted object IDs not to be returned.")}, responseDescription="Response with timestamp: An array with new and deleted attachments for the specified object. New attachments are represented by arrays. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter. Deleted attachments (should the ignore parameter be ever implemented) would be identified by their object IDs as plain numbers, without being part of a nested array.")
public final class UpdatesAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UpdatesAction.class));

    public UpdatesAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            UpdatesAction.require(requestData, "folder", "module", "attached", "timestamp");
            int folderId = this.requireNumber(requestData, "folder");
            int attachedId = this.requireNumber(requestData, "attached");
            int moduleId = this.requireNumber(requestData, "module");
            long timestamp = -1L;
            try {
                timestamp = Long.parseLong(requestData.getParameter("timestamp").trim());
            }
            catch (NumberFormatException nfe) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("timestamp", requestData.getParameter("timestamp"));
            }
            AttachmentField[] columns = PARSER.getColumns(requestData.getParameterValues("columns"));
            AttachmentField sort = null;
            if (null != requestData.getParameter("sort")) {
                sort = AttachmentField.get(Integer.parseInt(requestData.getParameter("sort")));
            }
            int order = 1;
            if ("DESC".equalsIgnoreCase(requestData.getParameter("order"))) {
                order = -1;
            }
            String delete = requestData.getParameter("ignore");
            String timeZoneId = requestData.getParameter("timezone");
            return new AJAXRequestResult((Object)this.updates(session, folderId, attachedId, moduleId, timestamp, "deleted".equals(delete), columns, sort, order, timeZoneId), "apiResponse");
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (AttachmentParser.UnknownColumnException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)((Object)e), e.getMessage());
        }
    }

    private JSONValue updates(ServerSession session, int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, AttachmentField[] fields, AttachmentField sort, int order, String timeZoneId) throws OXException {
        SearchIterator iter = null;
        SearchIterator iter2 = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            Context ctx = session.getContext();
            User user = session.getUser();
            UserConfiguration userConfig = session.getUserConfiguration();
            Delta<AttachmentMetadata> delta = sort != null ? ATTACHMENT_BASE.getDelta(session, folderId, attachedId, moduleId, ts, ignoreDeleted, fields, sort, order, ctx, user, userConfig) : ATTACHMENT_BASE.getDelta(session, folderId, attachedId, moduleId, ts, ignoreDeleted, ctx, user, userConfig);
            iter = delta.results();
            iter2 = delta.getDeleted();
            OXJSONWriter w = new OXJSONWriter();
            AttachmentWriter aWriter = new AttachmentWriter(w);
            aWriter.timedResult(delta.sequenceNumber());
            aWriter.writeDelta(iter, iter2, fields, ignoreDeleted, null == timeZoneId ? TimeZoneUtils.getTimeZone(user.getTimeZone()) : TimeZoneUtils.getTimeZone(timeZoneId));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
            JSONValue jSONValue = w.getObject();
            return jSONValue;
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e1) {
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            if (iter2 != null) {
                try {
                    iter2.close();
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

