/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.POST, name="detach", description="Delete Attachment.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="attached", description="The ID of the base Object."), @Parameter(name="module", description="The type of the Object."), @Parameter(name="folder", description="The Folder of the Object.")}, requestBody="An array with the ids of the attachments to delete.", responseDescription="Nothing, except the standard response object with empty data, the timestamp of the updated object, and maybe errors.")
public final class DetachAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DetachAction.class));

    public DetachAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            DetachAction.require(requestData, "folder", "module", "attached");
            int folderId = this.requireNumber(requestData, "folder");
            int attachedId = this.requireNumber(requestData, "attached");
            int moduleId = this.requireNumber(requestData, "module");
            JSONArray idsArray = (JSONArray)requestData.getData();
            int[] ids = new int[idsArray.length()];
            for (int i = 0; i < idsArray.length(); ++i) {
                try {
                    ids[i] = idsArray.getInt(i);
                    continue;
                }
                catch (JSONException e) {
                    String string = idsArray.getString(i);
                    try {
                        ids[i] = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        throw AjaxExceptionCodes.IMVALID_PARAMETER.create(string);
                    }
                }
            }
            Date timestamp = this.detach(session, folderId, attachedId, moduleId, ids);
            return new AJAXRequestResult("", timestamp, "string");
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private Date detach(ServerSession session, int folderId, int attachedId, int moduleId, int[] ids) throws OXException {
        long timestamp = 0L;
        try {
            ATTACHMENT_BASE.startTransaction();
            Context ctx = session.getContext();
            User user = session.getUser();
            UserConfiguration userConfig = session.getUserConfiguration();
            timestamp = ATTACHMENT_BASE.detachFromObject(folderId, attachedId, moduleId, ids, session, ctx, user, userConfig);
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new Date(timestamp);
    }
}

