/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.ServiceAware;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.filestorage.FileStorageFolderIdentifier;
import com.openexchange.folderstorage.filestorage.FileStorageFolderImpl;
import com.openexchange.folderstorage.filestorage.FileStorageFolderStorageServiceRegistry;
import com.openexchange.folderstorage.filestorage.FileStorageFolderType;
import com.openexchange.folderstorage.filestorage.FileStorageId;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.type.FileStorageType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FileStorageFolderStorage
implements FolderStorage {
    private static final String PARAM = "file.Access";
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private static final String INFOSTORE = Integer.toString(9);
    private static final String SERVICE_INFOSTORE = "infostore";

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("FileStorageFolderStorage.getVisibleSubfolders()");
    }

    private FileStorageAccountAccess getFileStorageAccessForAccount(String serviceId, String accountId, Session session, ConcurrentMap<Key, FileStorageAccountAccess> accesses) throws OXException {
        FileStorageAccountAccess prev;
        Key key = Key.newInstance(accountId, serviceId);
        FileStorageAccountAccess accountAccess = (FileStorageAccountAccess)accesses.get(key);
        if (null == accountAccess && null != (prev = accesses.putIfAbsent(key, accountAccess = ((FileStorageServiceRegistry)FileStorageFolderStorageServiceRegistry.getServiceRegistry().getService(FileStorageServiceRegistry.class, true)).getFileStorageService(serviceId).getAccountAccess(accountId, session)))) {
            accountAccess = prev;
        }
        return accountAccess;
    }

    private void openFileStorageAccess(FileStorageAccountAccess accountAccess) throws OXException {
        if (!accountAccess.isConnected()) {
            accountAccess.connect();
        }
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{FileStorageContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return FileStorageContentType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)params.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null != accesses) {
            try {
                Collection values = accesses.values();
                for (FileStorageAccountAccess fsAccess : values) {
                    fsAccess.close();
                }
            }
            finally {
                params.putParameter(FileStorageFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folder.getParentID());
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
        fsFolder.setExists(false);
        String parentId = fsfi.getFolderId();
        fsFolder.setParentId(parentId);
        fsFolder.setName(folder.getName());
        fsFolder.setSubscribed(folder.isSubscribed());
        Session session = storageParameters.getSession();
        if (null == session) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            ArrayList<DefaultFileStoragePermission> fsPermissions = new ArrayList<DefaultFileStoragePermission>(permissions.length);
            for (Permission permission : permissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(permission.getEntity());
                fsPerm.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                fsPerm.setAdmin(permission.isAdmin());
                fsPerm.setGroup(permission.isGroup());
                fsPermissions.add(fsPerm);
            }
            fsFolder.setPermissions(fsPermissions);
        } else if ("".equals(parentId)) {
            FileStoragePermission[] messagingPermissions = new FileStoragePermission[1];
            DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
            fsPerm.setEntity(session.getUserId());
            fsPerm.setAllPermissions(128, 128, 128, 128);
            fsPerm.setAdmin(true);
            fsPerm.setGroup(false);
            messagingPermissions[0] = fsPerm;
            fsFolder.setPermissions(Arrays.asList(messagingPermissions));
        } else {
            FileStorageFolder parent = accountAccess.getFolderAccess().getFolder(parentId);
            List parentPermissions = parent.getPermissions();
            FileStoragePermission[] ffPermissions = new FileStoragePermission[parentPermissions.size()];
            int i = 0;
            for (FileStoragePermission parentPerm : parentPermissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(parentPerm.getEntity());
                fsPerm.setAllPermissions(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                fsPerm.setAdmin(parentPerm.isAdmin());
                fsPerm.setGroup(parentPerm.isGroup());
                ffPermissions[i++] = fsPerm;
            }
            fsFolder.setPermissions(Arrays.asList(ffPermissions));
        }
        String fullName = accountAccess.getFolderAccess().createFolder((FileStorageFolder)fsFolder);
        folder.setID(new FileStorageFolderIdentifier(serviceId, accountId, fullName).toString());
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(fsfi.getServiceId(), fsfi.getAccountId(), storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        String fullName = fsfi.getFolderId();
        FileStorageFolderAccess folderAccess = accountAccess.getFolderAccess();
        folderAccess.clearFolder(fullName, true);
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(fsfi.getServiceId(), fsfi.getAccountId(), storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        String fullName = fsfi.getFolderId();
        FileStorageFolderAccess folderAccess = accountAccess.getFolderAccess();
        folderAccess.deleteFolder(fullName, true);
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof FileStorageContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(((Object)contentType).toString());
        }
        return FileStorageFolderIdentifier.getFQN(null, null, null);
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return FileStorageType.getInstance();
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        String fullname = fsfi.getFolderId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        if (!"".equals(fullname)) {
            this.openFileStorageAccess(accountAccess);
            if (!accountAccess.getFolderAccess().exists(fullname)) {
                throw FileStorageExceptionCodes.FOLDER_NOT_FOUND.create(new Object[]{fullname, Integer.valueOf(accountId), serviceId, storageParameters.getUserId(), storageParameters.getContextId()});
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        String fullname = fsfi.getFolderId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        if ("".equals(fullname)) {
            return 0 == accountAccess.getRootFolder().getFileCount();
        }
        this.openFileStorageAccess(accountAccess);
        return 0 == accountAccess.getFolderAccess().getFolder(fullname).getFileCount();
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
        for (String folderId : folderIds) {
            ret.add(this.getFolder(treeId, folderId, storageType, storageParameters));
        }
        return ret;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        boolean hasSubfolders;
        FileStorageFolderImpl retval;
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        String fullname = fsfi.getFolderId();
        if ("".equals(fullname)) {
            FileStorageFolder rootFolder = accountAccess.getFolderAccess().getRootFolder();
            retval = new FileStorageFolderImpl(rootFolder, accountId, serviceId);
            FileStorageServiceRegistry fssr = (FileStorageServiceRegistry)FileStorageFolderStorageServiceRegistry.getServiceRegistry().getService(FileStorageServiceRegistry.class, true);
            FileStorageService fsService = fssr.getFileStorageService(serviceId);
            FileStorageAccount fsAccount = fsService.getAccountManager().getAccount(accountId, storageParameters.getSession());
            retval.setName(fsAccount.getDisplayName());
            hasSubfolders = rootFolder.hasSubfolders();
        } else {
            FileStorageFolder fsFolder = accountAccess.getFolderAccess().getFolder(fullname);
            retval = new FileStorageFolderImpl(fsFolder, accountId, serviceId);
            hasSubfolders = fsFolder.hasSubfolders();
        }
        retval.setTreeID(treeId);
        if (!"".equals(fullname) && !"INBOX".equals(fullname)) {
            List<FileStorageFolder> children = Arrays.asList(accountAccess.getFolderAccess().getSubfolders(fullname, true));
            Collections.sort(children, new SimpleFileStorageFolderComparator(storageParameters.getUser().getLocale()));
            String[] subfolderIds = new String[children.size()];
            int i = 0;
            for (FileStorageFolder child : children) {
                subfolderIds[i++] = FileStorageFolderIdentifier.getFQN(serviceId, accountId, child.getId());
            }
            retval.setSubfolderIDs(subfolderIds);
        } else {
            retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
        }
        return retval;
    }

    @Override
    public FolderType getFolderType() {
        return FileStorageFolderType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        Session s = storageParameters.getSession();
        if (null == s) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        ServerSession session = s instanceof ServerSession ? (ServerSession)s : ServerSessionAdapter.valueOf(s);
        if (REAL_TREE_ID.equals(treeId) ? PRIVATE_FOLDER_ID.equals(parentId) : INFOSTORE.equals(parentId)) {
            ArrayList<FileStorageAccount> accounts = new ArrayList<FileStorageAccount>(8);
            FileStorageServiceRegistry registry = (FileStorageServiceRegistry)FileStorageFolderStorageServiceRegistry.getServiceRegistry().getService(FileStorageServiceRegistry.class, true);
            List allServices = registry.getAllServices();
            for (FileStorageService fsService : allServices) {
                List userAccounts = fsService instanceof AccountAware ? ((AccountAware)fsService).getAccounts((Session)session) : fsService.getAccountManager().getAccounts((Session)session);
                for (FileStorageAccount userAccount : userAccounts) {
                    if (SERVICE_INFOSTORE.equals(userAccount.getId()) || "0".equals(userAccount.getId())) continue;
                    FileStorageAccountAccess accountAccess = userAccount.getFileStorageService().getAccountAccess(userAccount.getId(), (Session)session);
                    accountAccess.connect();
                    try {
                        FileStorageFolder rootFolder = accountAccess.getFolderAccess().getRootFolder();
                        if (null == rootFolder) continue;
                        accounts.add(userAccount);
                    }
                    finally {
                        accountAccess.close();
                    }
                }
            }
            if (accounts.isEmpty()) {
                return new SortableId[0];
            }
            int size = accounts.size();
            if (size > 1) {
                Collections.sort(accounts, new FileStorageAccountComparator(session.getUser().getLocale()));
            }
            ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(size);
            for (int j = 0; j < size; ++j) {
                FileStorageService tmp;
                FileStorageAccount acc = (FileStorageAccount)accounts.get(j);
                String serviceId = acc instanceof ServiceAware ? ((ServiceAware)acc).getServiceId() : (null == (tmp = acc.getFileStorageService()) ? null : tmp.getId());
                list.add(new FileStorageId(FileStorageFolderIdentifier.getFQN(serviceId, acc.getId(), ""), j, null));
            }
            return list.toArray(new SortableId[list.size()]);
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(parentId);
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        String fullname = fsfi.getFolderId();
        List<FileStorageFolder> children = Arrays.asList(accountAccess.getFolderAccess().getSubfolders(fullname, true));
        Collections.sort(children, new SimpleFileStorageFolderComparator(storageParameters.getUser().getLocale()));
        ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(children.size());
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            FileStorageFolder cur = children.get(j);
            list.add(new FileStorageId(FileStorageFolderIdentifier.getFQN(serviceId, accountId, cur.getId()), j, cur.getName()));
        }
        return list.toArray(new SortableId[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters params) {
        ConcurrentMap accesses = (ConcurrentMap)params.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null != accesses) {
            try {
                Collection values = accesses.values();
                for (FileStorageAccountAccess access : values) {
                    access.close();
                }
            }
            finally {
                params.putParameter(FileStorageFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        if (null == parameters.getSession()) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create();
        }
        return parameters.putParameterIfAbsent(FileStorageFolderType.getInstance(), PARAM, new ConcurrentHashMap());
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folderId);
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        return accountAccess.getFolderAccess().exists(fsfi.getFolderId());
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(FolderStorage.REAL_TREE_ID, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        FileStorageFolderIdentifier pfi;
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folder.getID());
        String serviceId = fsfi.getServiceId();
        String accountId = fsfi.getAccountId();
        String id = fsfi.getFolderId();
        FileStorageAccountAccess accountAccess = this.getFileStorageAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openFileStorageAccess(accountAccess);
        DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
        fsFolder.setExists(true);
        fsFolder.setId(id);
        if (null != folder.getParentID()) {
            pfi = new FileStorageFolderIdentifier(folder.getParentID());
            fsFolder.setParentId(pfi.getFolderId());
        } else {
            pfi = null;
        }
        if (null != folder.getName()) {
            fsFolder.setName(folder.getName());
        }
        fsFolder.setSubscribed(folder.isSubscribed());
        FileStoragePermission[] fsPermissions = null;
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            fsPermissions = new FileStoragePermission[permissions.length];
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                DefaultFileStoragePermission dmp = DefaultFileStoragePermission.newInstance();
                dmp.setEntity(permission.getEntity());
                dmp.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                dmp.setAdmin(permission.isAdmin());
                dmp.setGroup(permission.isGroup());
                fsPermissions[i] = dmp;
            }
            fsFolder.setPermissions(Arrays.asList(fsPermissions));
        }
        FileStorageFolder storageVersion = accountAccess.getFolderAccess().getFolder(id);
        String oldParent = storageVersion.getParentId();
        String oldName = storageVersion.getName();
        String newName = fsFolder.getName();
        boolean movePerformed = false;
        String newParent = fsFolder.getParentId();
        if (newParent != null) {
            String parentAccountID = pfi.getAccountId();
            if (accountId.equals(parentAccountID)) {
                if (!newParent.equals(oldParent)) {
                    boolean rename = null != newName && !newName.equals(oldName);
                    this.check4DuplicateFolder(accountAccess, newParent, rename ? newName : oldName);
                    String movedFolder = accountAccess.getFolderAccess().moveFolder(id, newParent);
                    if (rename) {
                        movedFolder = accountAccess.getFolderAccess().renameFolder(movedFolder, newName);
                    }
                    folder.setID(FileStorageFolderIdentifier.getFQN(serviceId, accountId, movedFolder));
                    movePerformed = true;
                }
            } else {
                FileStorageAccountAccess otherAccess = this.getFileStorageAccessForAccount(serviceId, parentAccountID, storageParameters.getSession(), accesses);
                this.openFileStorageAccess(otherAccess);
                try {
                    FileStorageFolder p = otherAccess.getFolderAccess().getFolder(newParent);
                    FileStoragePermission ownPermission = p.getOwnPermission();
                    if (ownPermission.getFolderPermission() < 8) {
                        throw FileStorageExceptionCodes.NO_CREATE_ACCESS.create(new Object[]{newParent});
                    }
                    this.check4DuplicateFolder(otherAccess, newParent, null == newName ? oldName : newName);
                    String destFullname = FileStorageFolderStorage.fullCopy(accountAccess, id, otherAccess, newParent, storageParameters.getUserId(), p.getCapabilities().contains("PERMISSIONS"));
                    accountAccess.getFolderAccess().deleteFolder(id, true);
                    otherAccess.getFolderAccess().updateFolder(destFullname, (FileStorageFolder)fsFolder);
                }
                finally {
                    otherAccess.close();
                }
            }
        }
        if (!movePerformed && newName != null && !newName.equals(oldName)) {
            id = accountAccess.getFolderAccess().renameFolder(id, newName);
            folder.setID(FileStorageFolderIdentifier.getFQN(serviceId, accountId, id));
        }
        accountAccess.getFolderAccess().updateFolder(id, (FileStorageFolder)fsFolder);
        if (null != fsPermissions && StorageParametersUtility.isHandDownPermissions(storageParameters)) {
            FileStorageFolderStorage.handDown(accountId, id, fsPermissions, accountAccess);
        }
    }

    private static void handDown(String accountId, String parentId, FileStoragePermission[] fsPermissions, FileStorageAccountAccess accountAccess) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = accountAccess.getFolderAccess().getSubfolders(parentId, true)) {
            DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
            fsFolder.setExists(true);
            String id = subfolder.getId();
            fsFolder.setId(id);
            fsFolder.setPermissions(Arrays.asList(fsPermissions));
            accountAccess.getFolderAccess().updateFolder(id, (FileStorageFolder)fsFolder);
            FileStorageFolderStorage.handDown(accountId, id, fsPermissions, accountAccess);
        }
    }

    private void check4DuplicateFolder(FileStorageAccountAccess accountAccess, String parentId, String name2check) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = accountAccess.getFolderAccess().getSubfolders(parentId, true)) {
            if (!name2check.equals(subfolder.getName())) continue;
            throw FileStorageExceptionCodes.DUPLICATE_FOLDER.create(new Object[]{name2check, parentId});
        }
    }

    private static String fullCopy(FileStorageAccountAccess srcAccess, String srcFullname, FileStorageAccountAccess destAccess, String destParent, int user, boolean hasPermissions) throws OXException {
        FileStorageFolder[] tmp;
        FileStorageFolder source = srcAccess.getFolderAccess().getFolder(srcFullname);
        DefaultFileStorageFolder mfd = new DefaultFileStorageFolder();
        mfd.setName(source.getName());
        mfd.setParentId(destParent);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            List perms = source.getPermissions();
            for (FileStoragePermission perm : perms) {
                mfd.addPermission((FileStoragePermission)perm.clone());
            }
        }
        String destFullname = destAccess.getFolderAccess().createFolder((FileStorageFolder)mfd);
        for (FileStorageFolder element : tmp = srcAccess.getFolderAccess().getSubfolders(srcFullname, true)) {
            FileStorageFolderStorage.fullCopy(srcAccess, element.getId(), destAccess, destFullname, user, hasPermissions);
        }
        return destFullname;
    }

    private static final class FileStorageFolderComparator
    implements Comparator<FileStorageFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        FileStorageFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(FileStorageFolder o1, FileStorageFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getId()).compareTo(this.getNumberOf(o2.getId()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class SimpleFileStorageFolderComparator
    implements Comparator<FileStorageFolder> {
        private final Collator collator;

        SimpleFileStorageFolderComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FileStorageFolder o1, FileStorageFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class FileStorageAccountComparator
    implements Comparator<FileStorageAccount> {
        private final Collator collator;

        FileStorageAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FileStorageAccount o1, FileStorageAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static final class Key {
        private final String accountId;
        private final String serviceId;
        private final int hash;

        static Key newInstance(String accountId, String serviceId) {
            return new Key(accountId, serviceId);
        }

        private Key(String accountId, String serviceId) {
            this.accountId = accountId;
            this.serviceId = serviceId;
            int prime = 31;
            int result = 1;
            result = 31 * result + (accountId == null ? 0 : accountId.hashCode());
            this.hash = result = 31 * result + (serviceId == null ? 0 : serviceId.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
                return false;
            }
            return !(this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId));
        }
    }
}

