/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.internal.CallbackInputStream;
import com.openexchange.filemanagement.internal.FileRemovedListener;
import com.openexchange.filemanagement.internal.FileRemovedRegistry;
import com.openexchange.filemanagement.internal.ManagedFileImageDataSource;
import com.openexchange.filemanagement.internal.ManagedFileManagementImpl;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.image.ImageLocation;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;

final class ManagedFileImpl
implements ManagedFile,
FileRemovedRegistry {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ManagedFileImpl.class));
    private static final ManagedFileImageDataSource IMAGE_DATA_SOURCE = new ManagedFileImageDataSource();
    private final String id;
    private final File file;
    private volatile long lastAccessed;
    private final BlockingQueue<FileRemovedListener> listeners;
    private volatile String contentType;
    private volatile String fileName;
    private volatile long size;
    private String contentDisposition;

    ManagedFileImpl(String id, File file) {
        this.id = id;
        this.file = file;
        this.lastAccessed = System.currentTimeMillis();
        this.listeners = new LinkedBlockingQueue<FileRemovedListener>();
    }

    public String constructURL(Session session) throws OXException {
        String route;
        String prefix;
        if (null != this.contentType && this.contentType.regionMatches(true, 0, "image/", 0, 6)) {
            return IMAGE_DATA_SOURCE.generateUrl(new ImageLocation.Builder(this.id).build(), session);
        }
        StringBuilder sb = new StringBuilder(64);
        HostData hostData = (HostData)session.getParameter("com.openexchange.groupware.hostdata");
        if (hostData == null) {
            prefix = "";
            route = null;
        } else {
            sb.append(hostData.isSecure() ? "https://" : "http://");
            sb.append(hostData.getHost());
            int port = hostData.getPort();
            if (hostData.isSecure() && port != 443 || !hostData.isSecure() && port != 80) {
                sb.append(':').append(port);
            }
            prefix = sb.toString();
            sb.setLength(0);
            route = hostData.getRoute();
        }
        sb.append(prefix).append(DefaultDispatcherPrefixService.getInstance().getPrefix()).append("file");
        if (null != route) {
            sb.append(";jsessionid=").append(route);
        }
        sb.append('?').append("id=").append(this.id);
        sb.append('&').append("session=").append(session.getSessionID());
        sb.append('&').append("action=get");
        return sb.toString();
    }

    public void delete() {
        if (this.file.exists()) {
            while (!this.listeners.isEmpty()) {
                FileRemovedListener frl = (FileRemovedListener)this.listeners.poll();
                if (null == frl) continue;
                frl.removePerformed(this.file);
            }
            if (!this.file.delete() && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Temporary file could not be deleted: " + this.file.getPath()));
            }
        }
        ManagedFileManagementImpl.getInstance().removeFromFiles(this.id);
    }

    public File getFile() {
        if (!this.file.exists()) {
            return null;
        }
        this.touch();
        return this.file;
    }

    public long getLastAccess() {
        return this.lastAccessed;
    }

    public boolean isDeleted() {
        return !this.file.exists();
    }

    @Override
    public void touch() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public String getID() {
        return this.id;
    }

    public InputStream getInputStream() throws OXException {
        if (!this.file.exists()) {
            return null;
        }
        this.touch();
        try {
            CallbackInputStream retval = new CallbackInputStream(new BufferedInputStream(new FileInputStream(this.file)), this);
            this.listeners.offer(retval);
            return retval;
        }
        catch (FileNotFoundException e) {
            throw ManagedFileExceptionErrorMessage.FILE_NOT_FOUND.create((Throwable)e, new Object[]{this.file.getPath()});
        }
    }

    @Override
    public void removeListener(FileRemovedListener listener) {
        this.listeners.remove(listener);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }
}

