/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.osgi;

import com.openexchange.caching.CacheService;
import com.openexchange.database.internal.Initialization;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CacheServiceCustomizer
implements ServiceTrackerCustomizer<CacheService, CacheService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CacheServiceCustomizer.class));
    private final BundleContext context;

    public CacheServiceCustomizer(BundleContext context) {
        this.context = context;
    }

    public CacheService addingService(ServiceReference<CacheService> reference) {
        CacheService service = (CacheService)this.context.getService(reference);
        LOG.info((Object)"Injecting CacheService into database bundle.");
        Initialization.getInstance().setCacheService(service);
        return service;
    }

    public void modifiedService(ServiceReference<CacheService> reference, CacheService service) {
    }

    public void removedService(ServiceReference<CacheService> reference, CacheService service) {
        LOG.info((Object)"Removing CacheService from database bundle.");
        Initialization.getInstance().removeCacheService();
        this.context.ungetService(reference);
    }
}

