/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal.wrapping;

import com.openexchange.database.internal.AssignmentImpl;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.ReplicationMonitor;
import com.openexchange.database.internal.wrapping.JDBC4PreparedStatementWrapper;
import com.openexchange.database.internal.wrapping.JDBC4StatementWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class JDBC4ConnectionReturner
implements Connection {
    private final Pools pools;
    private final AssignmentImpl assign;
    protected Connection delegate;
    private final boolean noTimeout;
    private final boolean write;
    private final boolean usedAsRead;

    public JDBC4ConnectionReturner(Pools pools, AssignmentImpl assign, Connection delegate, boolean noTimeout, boolean write, boolean usedAsRead) {
        this.pools = pools;
        this.assign = assign;
        this.delegate = delegate;
        this.noTimeout = noTimeout;
        this.write = write;
        this.usedAsRead = usedAsRead;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (null == this.delegate) {
            throw new SQLException("Connection is already closed.");
        }
        Connection toReturn = this.delegate;
        this.delegate = null;
        ReplicationMonitor.backAndIncrementTransaction(this.pools, this.assign, toReturn, this.noTimeout, this.write, this.usedAsRead);
    }

    @Override
    public void commit() throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4StatementWrapper(this.delegate.createStatement(), this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4StatementWrapper(this.delegate.createStatement(resultSetType, resultSetConcurrency), this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4StatementWrapper(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate == null || this.delegate.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql, autoGeneratedKeys), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql, columnIndexes), this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkForAlreadyClosed();
        return new JDBC4PreparedStatementWrapper(this.delegate.prepareStatement(sql, columnNames), this);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkForAlreadyClosed();
        this.delegate.setTypeMap(map);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkForAlreadyClosed();
        return this.delegate.unwrap(iface);
    }

    protected void checkForAlreadyClosed() throws SQLException {
        if (null == this.delegate) {
            throw new SQLException("Connection was already closed.");
        }
    }
}

