/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.internal.Configuration;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Timer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Timer.class));
    private final Lock waitingLock = new ReentrantLock();
    private final List<Runnable> waiting = new ArrayList<Runnable>();
    private final Lock runningLock = new ReentrantLock();
    private final Map<Runnable, ScheduledTimerTask> running = new HashMap<Runnable, ScheduledTimerTask>();
    private long interval = 10000L;
    private TimerService timer;

    void addTask(Runnable task) {
        if (null == this.timer) {
            this.addWaiting(task);
        } else {
            this.start(task);
        }
    }

    void configure(Configuration configuration) {
        this.interval = configuration.getLong(Configuration.Property.CLEANER_INTERVAL, this.interval);
    }

    void removeTask(Runnable task) {
        if (this.isWaiting(task)) {
            this.removeWaiting(task);
        } else {
            this.stop(task);
        }
    }

    public void setTimerService(TimerService timer) {
        this.timer = timer;
        this.startAll();
    }

    public void removeTimerService() {
        this.stopAll();
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWaiting(Runnable task) {
        this.waitingLock.lock();
        try {
            this.waiting.add(task);
        }
        finally {
            this.waitingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaiting(Runnable task) {
        this.waitingLock.lock();
        try {
            boolean bl = this.waiting.contains(task);
            return bl;
        }
        finally {
            this.waitingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeWaiting(Runnable task) {
        this.waitingLock.lock();
        try {
            boolean bl = this.waiting.remove(task);
            return bl;
        }
        finally {
            this.waitingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getFirstWaiting() {
        this.waitingLock.lock();
        try {
            Runnable runnable = this.waiting.isEmpty() ? null : this.waiting.remove(0);
            return runnable;
        }
        finally {
            this.waitingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Runnable task) {
        ScheduledTimerTask alreadyRunning;
        ScheduledTimerTask scheduled = this.timer.scheduleAtFixedRate(task, this.interval, this.interval);
        this.runningLock.lock();
        try {
            alreadyRunning = this.running.put(task, scheduled);
        }
        finally {
            this.runningLock.unlock();
        }
        if (alreadyRunning != null) {
            LOG.error((Object)"Duplicate start of cleaner task.");
            if (!alreadyRunning.cancel()) {
                LOG.error((Object)"Can not stop already running cleaner task.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(Runnable task) {
        ScheduledTimerTask scheduled;
        this.runningLock.lock();
        try {
            scheduled = this.running.remove(task);
        }
        finally {
            this.runningLock.unlock();
        }
        if (null == scheduled) {
            LOG.error((Object)"Unknown task to remove.");
            return;
        }
        if (!scheduled.cancel()) {
            LOG.error((Object)"Can not stop running cleaner task.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable stopSomeRunning() {
        ScheduledTimerTask scheduled;
        Runnable task;
        this.runningLock.lock();
        try {
            Iterator<Map.Entry<Runnable, ScheduledTimerTask>> iter = this.running.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry<Runnable, ScheduledTimerTask> entry = iter.next();
                task = entry.getKey();
                scheduled = entry.getValue();
                iter.remove();
            } else {
                task = null;
                scheduled = null;
            }
        }
        finally {
            this.runningLock.unlock();
        }
        if (null == scheduled) {
            return null;
        }
        if (!scheduled.cancel()) {
            LOG.error((Object)"Can not stop running cleaner task.");
        }
        return task;
    }

    private void startAll() {
        Runnable task;
        while ((task = this.getFirstWaiting()) != null) {
            this.start(task);
        }
    }

    private void stopAll() {
        Runnable task;
        while ((task = this.stopSomeRunning()) != null) {
            this.addWaiting(task);
        }
    }
}

