/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.Assignment;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.AssignmentImpl;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.wrapping.ConnectionReturnerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.pooling.PoolingException;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;

public final class ReplicationMonitor {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReplicationMonitor.class));
    private static final AtomicLong masterConnectionsFetched = new AtomicLong();
    private static final AtomicLong slaveConnectionsFetched = new AtomicLong();
    private static final AtomicLong masterInsteadOfSlaveFetched = new AtomicLong();
    static final FetchAndSchema TIMEOUT = new FetchAndSchema(){

        @Override
        public Connection get(Pools pools, AssignmentImpl assign, boolean write, boolean usedAsRead) throws PoolingException, OXException {
            int poolId = write ? assign.getWritePoolId() : assign.getReadPoolId();
            ConnectionPool pool = pools.getPool(poolId);
            Connection retval = (Connection)pool.get();
            try {
                String schema = assign.getSchema();
                if (null != schema && !retval.getCatalog().equals(schema)) {
                    retval.setCatalog(schema);
                }
            }
            catch (SQLException e) {
                try {
                    pool.back(retval);
                }
                catch (PoolingException e1) {
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
                throw DBPoolingExceptionCodes.SCHEMA_FAILED.create((Throwable)e, new Object[0]);
            }
            return ConnectionReturnerFactory.createConnection(pools, assign, retval, false, write, usedAsRead);
        }
    };
    static final FetchAndSchema NOTIMEOUT = new FetchAndSchema(){

        @Override
        public Connection get(Pools pools, AssignmentImpl assign, boolean write, boolean usedAsRead) throws OXException, PoolingException {
            int poolId = write ? assign.getWritePoolId() : assign.getReadPoolId();
            ConnectionPool pool = pools.getPool(poolId);
            Connection retval = pool.getWithoutTimeout();
            try {
                String schema = assign.getSchema();
                if (null != schema && !retval.getCatalog().equals(schema)) {
                    retval.setCatalog(schema);
                }
            }
            catch (SQLException e) {
                pool.backWithoutTimeout(retval);
                throw DBPoolingExceptionCodes.SCHEMA_FAILED.create((Throwable)e, new Object[0]);
            }
            return ConnectionReturnerFactory.createConnection(pools, assign, retval, true, write, usedAsRead);
        }
    };
    private static long lastLogged = 0L;

    private ReplicationMonitor() {
    }

    static Connection checkActualAndFallback(Pools pools, AssignmentImpl assign, boolean noTimeout, boolean write) throws OXException {
        return ReplicationMonitor.checkActualAndFallback(pools, assign, noTimeout ? NOTIMEOUT : TIMEOUT, write);
    }

    static Connection checkActualAndFallback(Pools pools, AssignmentImpl assign, FetchAndSchema fetch, boolean write) throws OXException {
        Connection retval;
        long clientTransaction = 0L;
        int tries = 0;
        do {
            ++tries;
            try {
                retval = fetch.get(pools, assign, write, false);
                ReplicationMonitor.incrementFetched(assign, write);
            }
            catch (PoolingException e) {
                OXException e1 = ReplicationMonitor.createException(assign, write, e);
                if (write || assign.getWritePoolId() == assign.getReadPoolId()) {
                    throw e1;
                }
                LOG.warn((Object)e1.getMessage(), (Throwable)e1);
                try {
                    retval = fetch.get(pools, assign, true, true);
                    ReplicationMonitor.incrementInstead();
                }
                catch (PoolingException e2) {
                    throw ReplicationMonitor.createException(assign, true, e2);
                }
            }
            if (write || !assign.isTransactionInitialized()) continue;
            try {
                clientTransaction = ReplicationMonitor.readTransaction(retval, assign.getContextId());
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
                try {
                    retval.close();
                }
                catch (SQLException e1) {
                    OXException e2 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    LOG.error((Object)e2.getMessage(), (Throwable)e2);
                }
                retval = null;
            }
        } while (null == retval && tries < 10);
        if (null == retval) {
            throw ReplicationMonitor.createException(assign, write, null);
        }
        if (!write && assign.isTransactionInitialized() && !ReplicationMonitor.isUpToDate(assign.getTransaction(), clientTransaction)) {
            OXException e1;
            LOG.debug((Object)("Slave " + assign.getReadPoolId() + " is not actual. Using master " + assign.getWritePoolId() + " instead."));
            Connection toReturn = retval;
            try {
                retval = fetch.get(pools, assign, true, true);
                ReplicationMonitor.incrementInstead();
                try {
                    toReturn.close();
                }
                catch (SQLException e) {
                    e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            catch (PoolingException e) {
                e1 = ReplicationMonitor.createException(assign, true, e);
                LOG.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return retval;
    }

    private static OXException createException(Assignment assign, boolean write, Throwable cause) {
        int poolId = write ? assign.getWritePoolId() : assign.getReadPoolId();
        return assign.getReadPoolId() == -1 ? DBPoolingExceptionCodes.NO_CONFIG_DB.create(cause, new Object[0]) : DBPoolingExceptionCodes.NO_CONNECTION.create(cause, new Object[]{Autoboxing.I((int)poolId)});
    }

    private static boolean isUpToDate(long masterTransaction, long slaveTransaction) {
        return slaveTransaction >= masterTransaction;
    }

    public static void backAndIncrementTransaction(Pools pools, AssignmentImpl assign, Connection con, boolean noTimeout, boolean write, boolean usedAsRead) {
        ConnectionPool pool;
        int poolId;
        if (write) {
            poolId = assign.getWritePoolId();
            if (poolId != assign.getReadPoolId() && !usedAsRead) {
                ReplicationMonitor.increaseTransactionCounter(assign, con);
            }
        } else {
            poolId = assign.getReadPoolId();
        }
        try {
            pool = pools.getPool(poolId);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (noTimeout) {
            pool.backWithoutTimeout(con);
        } else {
            try {
                pool.back(con);
            }
            catch (PoolingException e) {
                OXException e1 = DBPoolingExceptionCodes.RETURN_FAILED.create((Throwable)e, new Object[]{con.toString()});
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private static long readTransaction(Connection con, int ctxId) throws OXException {
        long retval;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT transaction FROM replicationMonitor WHERE cid=?");
            stmt.setInt(1, ctxId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw DBPoolingExceptionCodes.TRANSACTION_MISSING.create(new Object[]{Autoboxing.I((int)ctxId)});
            }
            retval = result.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void increaseTransactionCounter(AssignmentImpl assign, Connection con) {
        block13: {
            try {
                if (con.isClosed()) {
                    return;
                }
            }
            catch (SQLException e) {
                OXException e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
                return;
            }
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE replicationMonitor SET transaction=transaction+1 WHERE cid=?");
                stmt.setInt(1, assign.getContextId());
                stmt.execute();
                stmt.close();
                stmt = con.prepareStatement("SELECT transaction FROM replicationMonitor WHERE cid=?");
                stmt.setInt(1, assign.getContextId());
                result = stmt.executeQuery();
                if (result.next()) {
                    assign.setTransaction(result.getLong(1));
                } else {
                    LOG.error((Object)("Updating transaction for replication monitor failed for context " + assign.getContextId() + "."));
                }
                con.commit();
                DBUtils.autocommit(con);
            }
            catch (SQLException e) {
                DBUtils.rollback(con);
                if (1146 == e.getErrorCode()) {
                    if (lastLogged + 300000L < System.currentTimeMillis()) {
                        lastLogged = System.currentTimeMillis();
                        OXException e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                        LOG.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                } else {
                    OXException e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
                break block13;
            }
            finally {
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(result, stmt);
            }
            DBUtils.closeSQLStuff(result, stmt);
        }
    }

    public static void incrementFetched(Assignment assign, boolean write) {
        if (assign.getWritePoolId() == assign.getReadPoolId() || write) {
            masterConnectionsFetched.incrementAndGet();
        } else {
            slaveConnectionsFetched.incrementAndGet();
        }
    }

    private static void incrementInstead() {
        masterInsteadOfSlaveFetched.incrementAndGet();
    }

    public static long getMasterConnectionsFetched() {
        return masterConnectionsFetched.get();
    }

    public static long getSlaveConnectionsFetched() {
        return slaveConnectionsFetched.get();
    }

    public static long getMasterInsteadOfSlave() {
        return masterInsteadOfSlaveFetched.get();
    }

    static interface FetchAndSchema {
        public Connection get(Pools var1, AssignmentImpl var2, boolean var3, boolean var4) throws PoolingException, OXException;
    }
}

