/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.PoolLifeCycle;
import com.openexchange.database.internal.Timer;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public final class Pools
implements Runnable {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Pools.class));
    private final List<PoolLifeCycle> lifeCycles = new ArrayList<PoolLifeCycle>(2);
    private final Lock poolsLock = new ReentrantLock(true);
    private final Map<Integer, ConnectionPool> pools = new HashMap<Integer, ConnectionPool>();
    private final Runnable cleaner = new Runnable(){

        @Override
        public void run() {
            try {
                Thread thread = Thread.currentThread();
                String origName = thread.getName();
                thread.setName("PoolsCleaner");
                Pools.this.run();
                thread.setName(origName);
            }
            catch (Throwable t) {
                LOG.error((Object)t.getMessage(), t);
            }
        }
    };

    Pools(Timer timer) {
        timer.addTask(this.cleaner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionPool[] getPools() {
        ArrayList<ConnectionPool> retval = new ArrayList<ConnectionPool>();
        this.poolsLock.lock();
        try {
            retval.addAll(this.pools.values());
        }
        finally {
            this.poolsLock.unlock();
        }
        return retval.toArray(new ConnectionPool[retval.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionPool getPool(int poolId) throws OXException {
        ConnectionPool retval;
        this.poolsLock.lock();
        try {
            retval = this.pools.get(Autoboxing.I((int)poolId));
            if (null == retval) {
                PoolLifeCycle lifeCycle;
                Iterator<PoolLifeCycle> i$ = this.lifeCycles.iterator();
                while (i$.hasNext() && null == (retval = (lifeCycle = i$.next()).create(poolId))) {
                }
                if (null == retval) {
                    throw DBPoolingExceptionCodes.NO_DBPOOL.create(new Object[]{Autoboxing.I((int)poolId)});
                }
                this.pools.put(Autoboxing.I((int)poolId), retval);
            }
        }
        finally {
            this.poolsLock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.trace((Object)"Starting cleaner run.");
        this.poolsLock.lock();
        try {
            Iterator<Map.Entry<Integer, ConnectionPool>> iter = this.pools.entrySet().iterator();
            while (iter.hasNext()) {
                PoolLifeCycle lifeCycle;
                Map.Entry<Integer, ConnectionPool> entry = iter.next();
                ConnectionPool pool = entry.getValue();
                if (!pool.isEmpty()) continue;
                iter.remove();
                boolean destroyed = false;
                Iterator<PoolLifeCycle> i$ = this.lifeCycles.iterator();
                while (i$.hasNext() && !(destroyed = (lifeCycle = i$.next()).destroy(entry.getKey()))) {
                }
                if (destroyed) continue;
                OXException e = DBPoolingExceptionCodes.UNKNOWN_POOL.create(new Object[]{entry.getKey()});
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.poolsLock.unlock();
        }
        LOG.trace((Object)"Cleaner run ending.");
    }

    void start(Timer timer) {
        timer.addTask(this.cleaner);
    }

    void addLifeCycle(PoolLifeCycle lifeCycle) {
        this.lifeCycles.add(lifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(Timer timer) {
        timer.removeTask(this.cleaner);
        this.poolsLock.lock();
        try {
            for (Map.Entry<Integer, ConnectionPool> entry : this.pools.entrySet()) {
                PoolLifeCycle lifeCycle;
                boolean destroyed = false;
                Iterator<PoolLifeCycle> i$ = this.lifeCycles.iterator();
                while (i$.hasNext() && !(destroyed = (lifeCycle = i$.next()).destroy(entry.getKey()))) {
                }
                if (destroyed) continue;
                OXException e = DBPoolingExceptionCodes.UNKNOWN_POOL.create(new Object[]{entry.getKey()});
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            this.pools.clear();
        }
        finally {
            this.poolsLock.unlock();
        }
    }
}

