/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.Overview;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.management.ManagementService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class Management {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Management.class));
    private final Map<Integer, ConnectionPool> pools = new ConcurrentHashMap<Integer, ConnectionPool>();
    private ManagementService managementService;
    private Overview overview;

    Management() {
    }

    public void removeManagementService() {
        this.unregisterMBeans();
        this.managementService = null;
    }

    public void setManagementService(ManagementService service) {
        this.managementService = service;
        this.registerMBeans();
    }

    private void registerPool(String name, ConnectionPool pool) {
        try {
            if (null != this.managementService) {
                ObjectName objName = new ObjectName("com.openexchange.pooling", "name", name);
                this.managementService.registerMBean(objName, (Object)pool);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void registerMBeans() {
        for (Map.Entry<Integer, ConnectionPool> entry : this.pools.entrySet()) {
            this.registerPool(Management.createMBeanName(entry.getKey()), entry.getValue());
        }
        this.registerOverview();
    }

    private void registerOverview() {
        try {
            if (null != this.overview) {
                this.managementService.registerMBean(new ObjectName("com.openexchange.pooling", "name", "Overview"), (Object)this.overview);
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void unregisterMBean(String name) {
        try {
            if (null != this.managementService) {
                ObjectName objName = new ObjectName("com.openexchange.pooling", "name", name);
                this.managementService.unregisterMBean(objName);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterMBeans() {
        for (Map.Entry<Integer, ConnectionPool> entry : this.pools.entrySet()) {
            this.unregisterMBean(Management.createMBeanName(entry.getKey()));
        }
        try {
            this.managementService.unregisterMBean(new ObjectName("com.openexchange.pooling", "name", "Overview"));
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static String createMBeanName(int poolId) {
        switch (poolId) {
            case -1: {
                return "ConfigDB Read";
            }
            case -2: {
                return "ConfigDB Write";
            }
        }
        return "DB Pool " + poolId;
    }

    public void addPool(int poolId, ConnectionPool pool) {
        this.pools.put(Autoboxing.I((int)poolId), pool);
        if (null != this.managementService) {
            this.registerPool(Management.createMBeanName(poolId), pool);
        }
    }

    public void removePool(int poolId) {
        this.pools.remove(Autoboxing.I((int)poolId));
        if (null != this.managementService) {
            this.unregisterMBean(Management.createMBeanName(poolId));
        }
    }

    public void addOverview(Overview overview) {
        this.overview = overview;
        if (null != this.managementService) {
            this.registerOverview();
        }
    }
}

