/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public class ConversionWarning
extends OXException {
    private static final long serialVersionUID = -7593693106963732974L;
    private final int index;

    @Deprecated
    public ConversionWarning(int index, String message, Object ... args) {
        super(9999, "A severe error occurred.", null, new Object[0]);
        this.addCategory(Category.CATEGORY_ERROR);
        this.setLogMessage(message, args);
        this.setPrefix("ICA");
        this.index = index;
    }

    @Deprecated
    public String getFormattedMessage() {
        return this.getLogMessage();
    }

    public ConversionWarning(int index, Code code, Object ... args) {
        this(index, code, null, args);
    }

    public ConversionWarning(int index, Code code, Throwable cause, Object ... args) {
        super(code.getNumber(), ConversionWarning.isDisplay(code) ? code.getMessage() : "A severe error occurred.", cause, ConversionWarning.isDisplay(code) ? args : new Object[]{});
        if (!ConversionWarning.isDisplay(code)) {
            this.setLogMessage(code.getMessage(), args);
        }
        this.addCategory(code.getCategory());
        this.setPrefix(code.getPrefix());
        this.index = index;
    }

    public ConversionWarning(int index, OXException cause) {
        super(cause);
        this.index = index;
    }

    private static boolean isDisplay(Code code) {
        return code.getCategory().getLogLevel().implies(LogLevel.DEBUG);
    }

    public int getIndex() {
        return this.index;
    }

    public static enum Code implements OXExceptionCode
    {
        INVALID_STATUS("Unable to convert task status \"%1$s\".", Category.CATEGORY_USER_INPUT, 1),
        INVALID_PRIORITY("Unable to convert task priority %d.", Category.CATEGORY_USER_INPUT, 2),
        CANT_CREATE_RRULE("Can not create recurrence rule: %s", Category.CATEGORY_ERROR, 3),
        INVALID_SESSION("Invalid session given to implementation \"%1$s\".", Category.CATEGORY_ERROR, 4),
        CANT_GENERATE_UID("Can not generate uid.", Category.CATEGORY_ERROR, 5),
        WRITE_PROBLEM("Problem writing to stream.", Category.CATEGORY_CONNECTIVITY, 6),
        VALIDATION("Validation of calendar failed.", Category.CATEGORY_ERROR, 7),
        CANT_RESOLVE_USER("Can not resolve user: %d", Category.CATEGORY_ERROR, 8),
        PARSE_EXCEPTION("Parsing error parsing ical: %s", Category.CATEGORY_USER_INPUT, 9),
        UNKNOWN_CLASS("Unknown Class: %1$s", Category.CATEGORY_USER_INPUT, 10),
        CLASS_CONFIDENTIAL("Cowardly refusing to convert confidential classified objects.", Category.CATEGORY_USER_INPUT, 11),
        MISSING_DTSTART("Missing DTSTART", Category.CATEGORY_USER_INPUT, 12),
        CANT_RESOLVE_RESOURCE("Can not resolve resource: %1$s", Category.CATEGORY_ERROR, 13),
        PRIVATE_APPOINTMENTS_HAVE_NO_PARTICIPANTS("Private appointments can not have attendees. Removing attendees and accepting appointment anyway.", Category.CATEGORY_USER_INPUT, 14),
        BYMONTH_NOT_SUPPORTED("Not supported recurrence pattern: BYMONTH", Category.CATEGORY_USER_INPUT, 15),
        DOES_NOT_LOOK_LIKE_ICAL_FILE("This does not look like an iCal file. Please check the file.", Category.CATEGORY_USER_INPUT, 16),
        EMPTY_CLASS("Empty \"CLASS\" element.", Category.CATEGORY_USER_INPUT, 17),
        INSUFFICIENT_INFORMATION("Insufficient information for parsing/writing this element.", Category.CATEGORY_ERROR, 18),
        UNEXPECTED_ERROR("An error occurred: %1$s", Category.CATEGORY_ERROR, 19);

        private final String message;
        private final Category category;
        private final int number;

        private Code(String message, Category category, int number) {
            this.message = message;
            this.category = category;
            this.number = number;
        }

        public String getPrefix() {
            return "ICA";
        }

        public String getMessage() {
            return this.message;
        }

        public Category getCategory() {
            return this.category;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(OXException e) {
            return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
        }

        public OXException create() {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
        }

        public OXException create(Object ... args) {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
        }

        public OXException create(Throwable cause, Object ... args) {
            return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
        }
    }
}

