/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.json.ConfigAJAXRequest;
import com.openexchange.config.json.actions.AbstractConfigAction;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="config/path", description="Get configuration data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="Value of the node specified by path.")
public final class GETAction
extends AbstractConfigAction {
    public GETAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ConfigAJAXRequest req) throws OXException, JSONException {
        String path = req.getRequest().getSerlvetRequestURI();
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ServerSession session = req.getSession();
        SettingStorage stor = SettingStorage.getInstance(session);
        Setting setting = ConfigTree.getInstance().getSettingByPath(path);
        stor.readValues(setting);
        Object object = GETAction.convert2JS(setting);
        if (object instanceof JSONValue) {
            return new AJAXRequestResult(object, "json");
        }
        if (object instanceof Number) {
            return new AJAXRequestResult(object, "int");
        }
        if (object instanceof Date) {
            return new AJAXRequestResult(object, "date");
        }
        return new AJAXRequestResult((Object)object.toString(), "string");
    }

    public static Object convert2JS(Setting setting) throws JSONException {
        Object retval = null;
        if (setting.isLeaf()) {
            Object[] multiValue = setting.getMultiValue();
            if (null == multiValue) {
                Object singleValue = setting.getSingleValue();
                if (null == singleValue) {
                    retval = JSONObject.NULL;
                } else if (singleValue instanceof JSONObject) {
                    retval = singleValue;
                } else {
                    try {
                        retval = new JSONObject(singleValue.toString());
                    }
                    catch (JSONException e) {
                        retval = singleValue;
                    }
                }
            } else {
                JSONArray array = new JSONArray();
                for (Object value : multiValue) {
                    array.put(value);
                }
                retval = array;
            }
        } else {
            JSONObject json = new JSONObject();
            for (Setting subSetting : setting.getElements()) {
                json.put(subSetting.getName(), GETAction.convert2JS(subSetting));
            }
            retval = json;
        }
        return retval;
    }
}

