/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.dynamic.impl;

import com.openexchange.cache.dynamic.OXNoRefresh;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheExceptionCode;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.LockAware;
import com.openexchange.caching.PutIfAbsent;
import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;

public class CachedObjectInvocationHandler<T>
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(CachedObjectInvocationHandler.class);
    private static final Method EQUALS;
    private T cached;
    private final OXObjectFactory<T> factory;
    private final String regionName;

    public CachedObjectInvocationHandler(OXObjectFactory<T> factory, String regionName) throws OXException {
        this.factory = factory;
        this.regionName = regionName;
        this.refresh();
    }

    @Override
    public final Object invoke(Object object, Method method, Object[] arguments) throws Throwable {
        if (!method.isAnnotationPresent(OXNoRefresh.class) || null == this.cached) {
            this.refresh();
        }
        if (EQUALS.equals(method)) {
            Object other = arguments[0];
            return other.equals(this.cached);
        }
        method.setAccessible(true);
        return method.invoke(this.cached, arguments);
    }

    private Cache getCache() throws OXException {
        CacheService service = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == service) {
            return null;
        }
        return service.getCache(this.regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() throws OXException {
        boolean load;
        Cache cache = this.getCache();
        if (null == cache) {
            if (null == this.cached) {
                this.cached = this.factory.load();
            }
            return;
        }
        if (cache.isDistributed()) {
            Serializable key = this.factory.getKey();
            Object retval = cache.get(key);
            if (null == retval) {
                try {
                    if (cache instanceof PutIfAbsent) {
                        Object newVal = this.factory.load();
                        retval = ((PutIfAbsent)cache).putIfAbsent(key, (Serializable)newVal);
                        if (null == retval) {
                            retval = newVal;
                        }
                    } else {
                        try {
                            Object newVal = this.factory.load();
                            cache.putSafe(key, (Serializable)newVal);
                            retval = newVal;
                        }
                        catch (OXException e) {
                            if (!CacheExceptionCode.FAILED_SAFE_PUT.equals(e)) {
                                throw e;
                            }
                            retval = cache.get(key);
                        }
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw CacheExceptionCode.CACHE_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
            this.cached = retval;
            return;
        }
        Lock lock = cache instanceof LockAware ? ((LockAware)cache).getLock() : this.factory.getCacheLock();
        Condition cond = null;
        lock.lock();
        try {
            Object tmp = cache.get(this.factory.getKey());
            if (null == tmp) {
                load = true;
                cond = lock.newCondition();
                cache.putSafe(this.factory.getKey(), (Serializable)((Object)cond));
            } else if (tmp instanceof Condition) {
                cond = (Condition)tmp;
                if (cond.await(1L, TimeUnit.SECONDS)) {
                    load = false;
                    this.cached = cache.get(this.factory.getKey());
                } else {
                    LOG.warn((Object)"Found 2 threads loading cached objects after 1 second.");
                    load = true;
                }
            } else {
                this.cached = tmp;
                load = false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            load = true;
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        if (load) {
            this.cached = this.factory.load();
            lock.lock();
            try {
                cond.signalAll();
                cache.put(this.factory.getKey(), (Serializable)this.cached);
            }
            finally {
                lock.unlock();
            }
        }
    }

    static {
        try {
            EQUALS = Object.class.getMethod("equals", Object.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

