/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.CalendarWriter;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskWriter
extends CalendarWriter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TaskWriter.class));
    private static final TIntObjectMap<TaskFieldWriter> WRITER_MAP;

    public TaskWriter(TimeZone timeZone) {
        super(timeZone, null);
    }

    public void writeArray(Task taskObject, int[] columns, JSONArray jsonArray) throws JSONException {
        JSONArray jsonTaskArray = new JSONArray();
        for (int column : columns) {
            this.writeField(taskObject, column, this.timeZone, jsonTaskArray);
        }
        jsonArray.put((Object)jsonTaskArray);
    }

    public void writeTask(Task task, JSONObject json) throws JSONException {
        super.writeFields(task, this.timeZone, json);
        TaskWriter.writeParameter("title", task.getTitle(), json);
        TaskWriter.writeParameter("start_date", task.getStartDate(), json);
        TaskWriter.writeParameter("end_date", task.getEndDate(), json);
        TaskWriter.writeParameter("actual_costs", task.getActualCosts(), json, task.containsActualCosts());
        TaskWriter.writeParameter("actual_duration", task.getActualDuration(), json, task.containsActualDuration());
        TaskWriter.writeParameter("note", task.getNote(), json);
        TaskWriter.writeParameter("after_complete", task.getAfterComplete(), json);
        TaskWriter.writeParameter("billing_information", task.getBillingInformation(), json);
        TaskWriter.writeParameter("companies", task.getCompanies(), json);
        TaskWriter.writeParameter("currency", task.getCurrency(), json);
        TaskWriter.writeParameter("date_completed", task.getDateCompleted(), json);
        if (task.containsPercentComplete()) {
            TaskWriter.writeParameter("percent_completed", task.getPercentComplete(), json);
        }
        if (task.containsPriority()) {
            TaskWriter.writeParameter("priority", task.getPriority(), json);
        }
        if (task.containsStatus()) {
            TaskWriter.writeParameter("status", task.getStatus(), json);
        }
        TaskWriter.writeParameter("target_costs", task.getTargetCosts(), json, task.containsTargetCosts());
        TaskWriter.writeParameter("target_duration", task.getTargetDuration(), json, task.containsTargetDuration());
        TaskWriter.writeParameter("trip_meter", task.getTripMeter(), json);
        TaskWriter.writeParameter("alarm", task.getAlarm(), this.timeZone, json);
        TaskWriter.writeRecurrenceParameter(task, json);
        if (task.containsParticipants()) {
            json.put("participants", (Object)TaskWriter.getParticipantsAsJSONArray(task));
        }
        if (task.containsUserParticipants()) {
            json.put("users", (Object)TaskWriter.getUsersAsJSONArray(task));
        }
        TaskWriter.writeParameter("day_in_month", task.getDayInMonth(), json, task.containsDayInMonth());
        TaskWriter.writeParameter("days", task.getDays(), json, task.containsDays());
    }

    protected void writeField(Task task, int column, TimeZone tz, JSONArray json) throws JSONException {
        TaskFieldWriter writer = (TaskFieldWriter)WRITER_MAP.get(column);
        if (null != writer) {
            writer.write(task, json);
            return;
        }
        if (super.writeField(task, column, tz, json)) {
            return;
        }
        switch (column) {
            case 204: {
                TaskWriter.writeValue(task.getAlarm(), tz, json);
                break;
            }
            default: {
                LOG.warn((Object)("Column " + column + " is unknown for tasks."));
            }
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(25, 1.0f);
        m.put(200, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getTitle(), jsonArray);
            }
        });
        m.put(201, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getStartDate(), jsonArray);
            }
        });
        m.put(202, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getEndDate(), jsonArray);
            }
        });
        m.put(203, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getNote(), jsonArray);
            }
        });
        m.put(302, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getActualCosts(), jsonArray, taskObject.containsActualCosts());
            }
        });
        m.put(303, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getActualDuration(), jsonArray, taskObject.containsActualDuration());
            }
        });
        m.put(305, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getBillingInformation(), jsonArray);
            }
        });
        m.put(314, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getCompanies(), jsonArray);
            }
        });
        m.put(312, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getCurrency(), jsonArray);
            }
        });
        m.put(315, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getDateCompleted(), jsonArray);
            }
        });
        m.put(301, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getPercentComplete(), jsonArray, taskObject.containsPercentComplete());
            }
        });
        m.put(309, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getPriority(), jsonArray, taskObject.containsPriority());
            }
        });
        m.put(300, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getStatus(), jsonArray, taskObject.containsStatus());
            }
        });
        m.put(307, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getTargetCosts(), jsonArray, taskObject.containsTargetCosts());
            }
        });
        m.put(308, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getTargetDuration(), jsonArray, taskObject.containsTargetDuration());
            }
        });
        m.put(313, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getTripMeter(), jsonArray);
            }
        });
        m.put(209, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getRecurrenceType(), jsonArray, taskObject.containsRecurrenceType());
            }
        });
        m.put(220, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) throws JSONException {
                jsonArray.put((Object)CalendarWriter.getParticipantsAsJSONArray(taskObject));
            }
        });
        m.put(221, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) throws JSONException {
                jsonArray.put((Object)CalendarWriter.getUsersAsJSONArray(taskObject));
            }
        });
        m.put(212, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getDays(), jsonArray, taskObject.containsDays());
            }
        });
        m.put(213, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getDayInMonth(), jsonArray, taskObject.containsDayInMonth());
            }
        });
        m.put(214, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getMonth(), jsonArray, taskObject.containsMonth());
            }
        });
        m.put(215, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getInterval(), jsonArray, taskObject.containsInterval());
            }
        });
        m.put(216, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task taskObject, JSONArray jsonArray) {
                DataWriter.writeValue(taskObject.getUntil(), jsonArray, taskObject.containsUntil());
            }
        });
        m.put(222, (Object)new TaskFieldWriter(){

            @Override
            public void write(Task task, JSONArray json) {
                DataWriter.writeValue(task.getOccurrence(), json, task.containsOccurrence());
            }
        });
        WRITER_MAP = m;
    }

    private static interface TaskFieldWriter {
        public void write(Task var1, JSONArray var2) throws JSONException;
    }
}

