/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.Log;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;

public class APIResponseRenderer
implements ResponseRenderer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(APIResponseRenderer.class));
    private static final String JSONP = "jsonp";
    private static final String CALLBACK = "callback";
    private static final String PLAIN_JSON = "plainJson";
    private static final String SESSION_KEY = "sessionObject";
    private static final String MULTIPART = "multipart/";
    private static final String JS_FRAGMENT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><script type=\"text/javascript\">(parent.callback_**action** || window.opener && window.opener.callback_**action**)(**json**)</script></head></html>";
    private static final Pattern RPL_JSON = Pattern.compile("**json**", 16);
    private static final Pattern RPL_ACTION = Pattern.compile("**action**", 16);

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof Response;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        Boolean plainJson = (Boolean)result.getParameter(PLAIN_JSON);
        APIResponseRenderer.writeResponse((Response)result.getResultObject(), request.getAction(), req, resp, null == plainJson ? false : plainJson);
    }

    protected static ServerSession getSession(ServletRequest req) {
        Object attribute = req.getAttribute(SESSION_KEY);
        if (attribute != null) {
            return (ServerSession)req.getAttribute(SESSION_KEY);
        }
        return null;
    }

    protected static Locale localeFrom(ServerSession session) {
        if (null == session) {
            return Locale.US;
        }
        return session.getUser().getLocale();
    }

    public static void writeResponse(Response response, String action, HttpServletRequest req, HttpServletResponse resp) {
        APIResponseRenderer.writeResponse(response, action, req, resp, false);
    }

    private static void writeResponse(Response response, String action, HttpServletRequest req, HttpServletResponse resp, boolean plainJson) {
        try {
            ServerSession session = APIResponseRenderer.getSession((ServletRequest)req);
            if (plainJson) {
                ResponseWriter.write(response, resp.getWriter(), APIResponseRenderer.localeFrom(session));
            } else if (APIResponseRenderer.isMultipartContent(req) || APIResponseRenderer.isRespondWithHTML(req) || req.getParameter(CALLBACK) != null) {
                resp.setContentType("text/html; charset=UTF-8");
                String callback = req.getParameter(CALLBACK);
                if (callback == null) {
                    callback = action;
                }
                AllocatingStringWriter w = new AllocatingStringWriter();
                ResponseWriter.write(response, (Writer)w, APIResponseRenderer.localeFrom(session));
                resp.getWriter().print(APIResponseRenderer.substituteJS(w.toString(), callback));
            } else if (req.getParameter(JSONP) != null) {
                String call = req.getParameter(JSONP);
                AllocatingStringWriter w = new AllocatingStringWriter();
                ResponseWriter.write(response, (Writer)w, APIResponseRenderer.localeFrom(session));
                StringAllocator sb = new StringAllocator(call);
                sb.append('(').append(w.toString()).append(");");
                resp.setContentType("text/javascript");
                resp.getWriter().write(sb.toString());
            } else {
                ResponseWriter.write(response, resp.getWriter(), APIResponseRenderer.localeFrom(session));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            try {
                resp.sendError(500, "A JSON error occurred: " + e.getMessage());
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static final boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    private static boolean isRespondWithHTML(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter("respondWithHTML"));
    }

    private static String substituteJS(String json, String action) {
        return RPL_ACTION.matcher(RPL_JSON.matcher(JS_FRAGMENT).replaceAll(Matcher.quoteReplacement(json))).replaceAll(Matcher.quoteReplacement(action));
    }
}

