/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.dispatcher.Parameterizable;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.strings.StringParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class AJAXRequestData {
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private Parameterizable parameterizable;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    private ServerSession session;
    private boolean secure;
    private Object data;
    private String module;
    private String action;
    private InputStreamProvider uploadStreamProvider;
    private final List<UploadFile> files = new LinkedList<UploadFile>();
    private String hostname;
    private String remoteAddress;
    private String servletRequestUri;
    private String route;
    private volatile UploadEvent uploadEvent;
    private String format;
    private AJAXState state;
    private String eTag;
    private long expires = -1L;
    private String pathInfo;
    private HttpServletRequest httpServletRequest;
    private final List<String> decoratorIds = new LinkedList<String>();
    private boolean multipart;
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public AJAXRequestData(JSONObject json) throws OXException {
        this();
        this.data = DataParser.checkJSONObject(json, "data");
    }

    public AJAXRequestData(Object data) {
        this();
        this.data = data;
    }

    public AJAXRequestData() {
    }

    public AJAXRequestData copyOf() {
        AJAXRequestData copy = new AJAXRequestData();
        copy.params.putAll(this.params);
        copy.headers.putAll(this.headers);
        copy.properties.putAll(this.properties);
        copy.decoratorIds.addAll(this.decoratorIds);
        copy.files.addAll(this.files);
        copy.parameterizable = this.parameterizable;
        copy.session = this.session;
        copy.secure = this.secure;
        copy.action = this.action;
        copy.data = this.data;
        copy.eTag = this.eTag;
        copy.expires = this.expires;
        copy.format = this.format;
        copy.hostname = this.hostname;
        copy.module = this.module;
        copy.pathInfo = this.pathInfo;
        copy.remoteAddress = this.remoteAddress;
        copy.route = this.route;
        copy.servletRequestUri = this.servletRequestUri;
        copy.state = null;
        copy.uploadEvent = null;
        copy.uploadStreamProvider = null;
        return copy;
    }

    public void examineServletRequest(HttpServletRequest servletRequest) {
        if (null == servletRequest) {
            return;
        }
        this.parameterizable = servletRequest instanceof Parameterizable ? (Parameterizable)servletRequest : null;
    }

    public AJAXRequestData addDecoratorId(String decoratorId) {
        this.decoratorIds.add(decoratorId);
        return this;
    }

    public AJAXRequestData addDecoratorIds(Collection<String> decoratorIds) {
        List<String> thisDecoratorIds = this.decoratorIds;
        for (String decoratorId : decoratorIds) {
            thisDecoratorIds.add(decoratorId);
        }
        return this;
    }

    public List<String> getDecoratorIds() {
        return this.decoratorIds;
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.examineServletRequest(httpServletRequest);
        this.httpServletRequest = httpServletRequest;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setServletRequestURI(String servletRequestUri) {
        this.servletRequestUri = servletRequestUri;
    }

    public String getSerlvetRequestURI() {
        return this.servletRequestUri;
    }

    public void putParameter(String name, String value) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        if (null == value) {
            this.params.remove(name);
        } else {
            this.params.put(name, value);
        }
        Parameterizable parameterizable = this.parameterizable;
        if (null != parameterizable) {
            parameterizable.putParameter(name, value);
        }
    }

    public boolean containsParameter(String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        return this.params.containsKey(name);
    }

    public int getIntParameter(String name) throws OXException {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            return -1;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, value);
        }
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.params);
    }

    public String[] getParameterValues(String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            return null;
        }
        return SPLIT.split(value, 0);
    }

    public String getParameter(String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        return this.params.get(name);
    }

    public String checkParameter(String name) throws OXException {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return value;
    }

    public int[] checkIntArray(String name) throws OXException {
        String parameter = this.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        if (name.equals("columns")) {
            if (parameter.equals("all")) {
                return AbstractMailAction.COLUMNS_ALL_ALIAS;
            }
            if (parameter.equals("list")) {
                return AbstractMailAction.COLUMNS_LIST_ALIAS;
            }
        }
        String[] sa = SPLIT.split(parameter, 0);
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            try {
                ret[i] = Integer.parseInt(sa[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return ret;
    }

    public String[] checkParameterArray(String name) throws OXException {
        String parameter = this.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return SPLIT.split(parameter, 0);
    }

    public <T> T getParameter(String name, Class<T> coerceTo) throws OXException {
        String value = this.getParameter(name);
        try {
            return (T)ServerServiceRegistry.getInstance().getService(StringParser.class).parse(value, coerceTo);
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, null == value ? "null" : value);
        }
    }

    public Iterator<String> getParameterNames() {
        return this.params.keySet().iterator();
    }

    public Iterator<Map.Entry<String, String>> getNonMatchingParameters(Collection<String> nonMatchingParameterNames) {
        HashMap<String, String> clone = new HashMap<String, String>(this.params);
        clone.keySet().removeAll(nonMatchingParameterNames);
        return clone.entrySet().iterator();
    }

    public Iterator<Map.Entry<String, String>> getMatchingParameters(Collection<String> matchingParameterNames) {
        HashMap<String, String> clone = new HashMap<String, String>(this.params);
        clone.keySet().retainAll(matchingParameterNames);
        return clone.entrySet().iterator();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isMultipartContent() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public InputStream getUploadStream() throws IOException {
        return this.uploadStreamProvider.getInputStream();
    }

    public void setUploadStreamProvider(InputStreamProvider uploadStreamProvider) {
        this.uploadStreamProvider = uploadStreamProvider;
    }

    public List<String> getMissingParameters(String ... mandatoryParameters) {
        ArrayList<String> missing = new ArrayList<String>(mandatoryParameters.length);
        for (String paramName : mandatoryParameters) {
            if (this.params.containsKey(paramName)) continue;
            missing.add(paramName);
        }
        return missing;
    }

    public void require(String ... mandatoryParameters) throws OXException {
        List<String> missingParameters = this.getMissingParameters(mandatoryParameters);
        if (!missingParameters.isEmpty()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(missingParameters.toString());
        }
    }

    public boolean isSet(String paramName) {
        return this.params.containsKey(paramName);
    }

    public void setHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public <T> T getHeader(String header, Class<T> coerceTo) {
        return (T)ServerServiceRegistry.getInstance().getService(StringParser.class).parse(this.getHeader(header), coerceTo);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public boolean hasUploads() throws OXException {
        this.processUpload();
        return !this.files.isEmpty();
    }

    public List<UploadFile> getFiles() throws OXException {
        this.processUpload();
        return Collections.unmodifiableList(this.files);
    }

    public UploadFile getFile(String name) throws OXException {
        this.processUpload();
        for (UploadFile file : this.files) {
            if (!file.getFieldName().equals(name)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpload() throws OXException {
        List<UploadFile> thisFiles;
        if (!this.multipart || null == this.httpServletRequest) {
            return;
        }
        List<UploadFile> list = thisFiles = this.files;
        synchronized (list) {
            UploadEvent uploadEvent = this.uploadEvent;
            if (null == uploadEvent) {
                uploadEvent = AJAXServlet.processUploadStatic(this.httpServletRequest);
                Iterator<UploadFile> iterator = uploadEvent.getUploadFilesIterator();
                while (iterator.hasNext()) {
                    thisFiles.add(iterator.next());
                }
                Iterator<String> names = uploadEvent.getFormFieldNames();
                while (names.hasNext()) {
                    String name = names.next();
                    this.putParameter(name, uploadEvent.getFormField(name));
                }
                this.uploadEvent = uploadEvent;
            }
        }
    }

    public StringBuilder constructURL(String protocol, String path, boolean withRoute, String query) {
        StringBuilder url = new StringBuilder();
        String prot = protocol;
        if (prot == null) {
            prot = this.isSecure() ? "https://" : "http://";
        }
        url.append(prot);
        if (!prot.endsWith("://")) {
            url.append("://");
        }
        url.append(this.hostname);
        if (path != null) {
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
        }
        if (withRoute) {
            url.append(";jsessionid=").append(this.route);
        }
        if (query != null) {
            if (query.length() == 0 || query.charAt(0) != '?') {
                url.append('?');
            }
            url.append(query);
        }
        return url;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getRoute() {
        return this.route;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public UploadEvent getUploadEvent() throws OXException {
        this.processUpload();
        return this.uploadEvent;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setData(Object object, String format) {
        this.setData(object);
        this.setFormat(format);
    }

    public void setState(AJAXState state) {
        this.state = state;
    }

    public AJAXState getState() {
        if (this.state == null) {
            this.state = new AJAXState();
        }
        return this.state;
    }

    public boolean containsProperty(String name) {
        if (null == name) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    public <V> V getProperty(String name) {
        if (null == name) {
            return null;
        }
        try {
            return (V)this.properties.get(name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        if (null == value) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

