/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.Mail;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public final class MailRequest {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailRequest.class));
    private static final Mail MAIL_SERVLET = new Mail();
    private final ServerSession session;
    private final OXJSONWriter writer;
    private CollectObject collectObj;
    private boolean contCollecting;

    public MailRequest(ServerSession session, OXJSONWriter writer) {
        this.session = session;
        this.writer = writer;
    }

    public void action(String action, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
        if (!this.session.getUserConfiguration().hasWebMail()) {
            throw AjaxExceptionCodes.NO_PERMISSION_FOR_MODULE.create("mail");
        }
        if (action.equalsIgnoreCase("all")) {
            MAIL_SERVLET.actionGetAllMails(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("count")) {
            MAIL_SERVLET.actionGetMailCount(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("updates")) {
            MAIL_SERVLET.actionGetUpdates(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.regionMatches(true, 0, "reply", 0, 5)) {
            if (jsonObject.has("data") && !jsonObject.isNull("data")) {
                MAIL_SERVLET.actionPutReply(this.session, action.equalsIgnoreCase("replyall"), this.writer, jsonObject, mailInterface);
            } else {
                MAIL_SERVLET.actionGetReply(this.session, this.writer, jsonObject, action.equalsIgnoreCase("replyall"), mailInterface);
            }
        } else if (action.equalsIgnoreCase("forward")) {
            if (jsonObject.has("data") && !jsonObject.isNull("data")) {
                MAIL_SERVLET.actionPutForwardMultiple(this.session, this.writer, jsonObject, mailInterface);
            } else {
                MAIL_SERVLET.actionGetForward(this.session, this.writer, jsonObject, mailInterface);
            }
        } else if (action.equalsIgnoreCase("get")) {
            if (jsonObject.has("data") && !jsonObject.isNull("data")) {
                MAIL_SERVLET.actionPutGet(this.session, this.writer, jsonObject, mailInterface);
            } else {
                MAIL_SERVLET.actionGetMessage(this.session, this.writer, jsonObject, mailInterface);
            }
        } else if (action.equalsIgnoreCase("get_structure")) {
            MAIL_SERVLET.actionGetStructure(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("attachment")) {
            MAIL_SERVLET.actionGetAttachment();
        } else if (action.equalsIgnoreCase("attachmentToken")) {
            MAIL_SERVLET.actionGetAttachmentToken(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("newmsgs")) {
            MAIL_SERVLET.actionGetNew(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("list")) {
            MAIL_SERVLET.actionPutMailList(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("delete")) {
            MAIL_SERVLET.actionPutDeleteMails(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("update")) {
            if (MailRequest.isMove(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.MOVE);
            } else if (MailRequest.isStoreFlags(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.STORE_FLAG);
            } else if (MailRequest.isColorLabel(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.COLOR_LABEL);
            } else {
                MAIL_SERVLET.actionPutUpdateMail(this.session, this.writer, jsonObject, mailInterface);
            }
        } else if (action.equalsIgnoreCase("transport")) {
            MAIL_SERVLET.actionPutTransportMail(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("copy")) {
            this.handleMultiple(jsonObject, mailInterface, CollectableOperation.COPY);
        } else if (action.equalsIgnoreCase("attachment")) {
            MAIL_SERVLET.actionPutAttachment(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("receipt_ack")) {
            MAIL_SERVLET.actionPutReceiptAck(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("search")) {
            MAIL_SERVLET.actionPutMailSearch(this.session, this.writer, jsonObject, mailInterface);
        } else if (action.equalsIgnoreCase("clear")) {
            MAIL_SERVLET.actionPutClear(this.session, this.writer, jsonObject, mailInterface);
        } else {
            throw MailExceptionCode.UNKNOWN_ACTION.create(action);
        }
    }

    private void handleMultiple(JSONObject jsonObject, MailServletInterface mailInterface, CollectableOperation op) throws JSONException {
        if (this.collectObj == null) {
            this.collectObj = CollectObject.newInstance(jsonObject, op, MAIL_SERVLET);
            this.collectObj.addCollectable(jsonObject);
            this.contCollecting = true;
        } else if (this.collectObj.collectable(jsonObject, op)) {
            this.collectObj.addCollectable(jsonObject);
            this.contCollecting = true;
        } else {
            this.performMultipleInternal(mailInterface);
            this.collectObj = CollectObject.newInstance(jsonObject, op, MAIL_SERVLET);
            this.collectObj.addCollectable(jsonObject);
            this.contCollecting = false;
        }
    }

    public boolean isContiguousCollect() {
        return this.contCollecting;
    }

    public void performMultiple(MailServletInterface mailInterface) throws JSONException {
        if (this.collectObj != null) {
            this.performMultipleInternal(mailInterface);
            this.collectObj = null;
        }
    }

    private void performMultipleInternal(MailServletInterface mailInterface) throws JSONException {
        if (LOG.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            this.collectObj.performOperations(this.session, this.writer, mailInterface);
            LOG.debug((Object)new StringAllocator(128).append("Multiple '").append(MailRequest.getOpName(this.collectObj.getOperation())).append("' mail request successfully performed: ").append(System.currentTimeMillis() - start).append("msec").toString());
        } else {
            this.collectObj.performOperations(this.session, this.writer, mailInterface);
        }
    }

    public static boolean isMove(JSONObject jsonObject) throws JSONException {
        return jsonObject.has("data") && jsonObject.getJSONObject("data").has("folder_id");
    }

    public static boolean isStoreFlags(JSONObject jsonObject) throws JSONException {
        return jsonObject.has("data") && jsonObject.getJSONObject("data").has(MailJSONField.FLAGS.getKey());
    }

    public static boolean isColorLabel(JSONObject jsonObject) throws JSONException {
        return jsonObject.has("data") && jsonObject.getJSONObject("data").has("color_label");
    }

    private static String getOpName(CollectableOperation op) {
        switch (op) {
            case MOVE: {
                return "Move";
            }
            case COPY: {
                return "Copy";
            }
            case STORE_FLAG: {
                return "Store Flag";
            }
            case COLOR_LABEL: {
                return "Color Label";
            }
        }
        throw new InternalError("Unknown collectable operation: " + (Object)((Object)op));
    }

    private static final class ColorCollectObject
    extends CollectObject {
        private final String srcFld;
        private final int flagInt;

        public ColorCollectObject(JSONObject dataObject, Mail mailServlet) throws JSONException {
            super(mailServlet);
            this.srcFld = dataObject.getString("folder");
            this.flagInt = dataObject.getJSONObject("data").getInt("color_label");
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws JSONException {
            return CollectableOperation.COLOR_LABEL.equals((Object)op) && this.srcFld.equals(dataObject.getString("folder")) && this.flagInt == dataObject.getJSONObject("data").getInt("color_label");
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.COLOR_LABEL;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutColorLabelMultiple(session, writer, this.getMailIDs(), this.srcFld, this.flagInt, mailInterface);
        }
    }

    private static final class FlagsCollectObject
    extends CollectObject {
        private final String srcFld;
        private final int flagInt;
        private final boolean flagValue;

        public FlagsCollectObject(JSONObject dataObject, Mail mailServlet) throws JSONException {
            super(mailServlet);
            this.srcFld = dataObject.getString("folder");
            JSONObject bodyObj = dataObject.getJSONObject("data");
            this.flagInt = bodyObj.getInt(MailJSONField.FLAGS.getKey());
            this.flagValue = bodyObj.getBoolean(MailJSONField.VALUE.getKey());
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws JSONException {
            JSONObject bodyObj = dataObject.getJSONObject("data");
            return CollectableOperation.STORE_FLAG.equals((Object)op) && this.srcFld.equals(dataObject.getString("folder")) && this.flagInt == bodyObj.getInt(MailJSONField.FLAGS.getKey()) && this.flagValue == bodyObj.getBoolean(MailJSONField.VALUE.getKey());
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.STORE_FLAG;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutStoreFlagsMultiple(session, writer, this.getMailIDs(), this.srcFld, this.flagInt, this.flagValue, mailInterface);
        }
    }

    private static final class CopyCollectObject
    extends CollectObject {
        private final String srcFld;
        private final String destFld;

        public CopyCollectObject(JSONObject dataObject, Mail mailServlet) throws JSONException {
            super(mailServlet);
            this.srcFld = dataObject.getString("folder");
            this.destFld = dataObject.getJSONObject("data").getString("folder_id");
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws JSONException {
            return CollectableOperation.COPY.equals((Object)op) && this.srcFld.equals(dataObject.getString("folder")) && this.destFld.equals(dataObject.getJSONObject("data").getString("folder_id"));
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.COPY;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutMailMultiple(session, writer, this.getMailIDs(), this.srcFld, this.destFld, false, mailInterface);
        }
    }

    private static final class MoveCollectObject
    extends CollectObject {
        private final String srcFld;
        private final String destFld;

        public MoveCollectObject(JSONObject dataObject, Mail mailServlet) throws JSONException {
            super(mailServlet);
            this.srcFld = dataObject.getString("folder");
            this.destFld = dataObject.getJSONObject("data").getString("folder_id");
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws JSONException {
            return CollectableOperation.MOVE.equals((Object)op) && this.srcFld.equals(dataObject.getString("folder")) && this.destFld.equals(dataObject.getJSONObject("data").getString("folder_id"));
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.MOVE;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutMailMultiple(session, writer, this.getMailIDs(), this.srcFld, this.destFld, true, mailInterface);
        }
    }

    private static abstract class CollectObject {
        protected final Mail mailServlet;
        protected final List<String> mailIDs = new ArrayList<String>();

        public static CollectObject newInstance(JSONObject jsonObject, CollectableOperation op, Mail mailServlet) throws JSONException {
            switch (op) {
                case COPY: {
                    return new CopyCollectObject(jsonObject, mailServlet);
                }
                case MOVE: {
                    return new MoveCollectObject(jsonObject, mailServlet);
                }
                case STORE_FLAG: {
                    return new FlagsCollectObject(jsonObject, mailServlet);
                }
                case COLOR_LABEL: {
                    return new ColorCollectObject(jsonObject, mailServlet);
                }
            }
            throw new InternalError("Unknown collectable operation: " + (Object)((Object)op));
        }

        protected CollectObject(Mail mailServlet) {
            this.mailServlet = mailServlet;
        }

        public abstract boolean collectable(JSONObject var1, CollectableOperation var2) throws JSONException;

        public abstract void performOperations(ServerSession var1, OXJSONWriter var2, MailServletInterface var3) throws JSONException;

        public abstract CollectableOperation getOperation();

        public final void addCollectable(JSONObject jsonObject) throws JSONException {
            this.mailIDs.add(jsonObject.getString("id"));
        }

        protected final String[] getMailIDs() {
            return this.mailIDs.toArray(new String[this.mailIDs.size()]);
        }
    }

    private static enum CollectableOperation {
        MOVE,
        COPY,
        STORE_FLAG,
        COLOR_LABEL;

    }
}

