/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestHandler;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.server.services.ServerRequestHandlerRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class GroupRequest {
    private final ServerSession session;
    private Date timestamp;
    private static final String MODULE_GROUP = "group";

    public GroupRequest(ServerSession session) {
        this.session = session;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object action(String action, JSONObject jsonObject) throws OXException, JSONException {
        JSONArray retval = null;
        if (action.equalsIgnoreCase("list")) {
            retval = this.actionList(jsonObject);
        } else if (action.equalsIgnoreCase("get")) {
            retval = this.actionGet(jsonObject);
        } else if (action.equalsIgnoreCase("search")) {
            retval = this.actionSearch(jsonObject);
        } else if (action.equalsIgnoreCase("all")) {
            retval = this.actionAll(jsonObject);
        } else if (action.equalsIgnoreCase("updates")) {
            retval = this.actionUpdates(jsonObject);
        } else {
            AJAXRequestHandler handler = ServerRequestHandlerRegistry.getInstance().getHandler(MODULE_GROUP, action);
            if (null == handler) {
                throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
            }
            AJAXRequestResult result = handler.performAction(action, jsonObject, this.session, this.session.getContext());
            this.timestamp = result.getTimestamp();
            return result.getResultObject();
        }
        return retval;
    }

    public JSONValue actionUpdates(JSONObject jsonObject) throws JSONException, OXException {
        JSONObject temp;
        this.timestamp = new Date(0L);
        GroupStorage groupStorage = GroupStorage.getInstance();
        Date modifiedSince = DataParser.checkDate(jsonObject, "timestamp");
        Group[] modifiedGroups = groupStorage.listModifiedGroups(modifiedSince, this.session.getContext());
        Group[] deletedGroups = groupStorage.listDeletedGroups(modifiedSince, this.session.getContext());
        GroupWriter groupWriter = new GroupWriter();
        JSONArray modified = new JSONArray();
        JSONArray deleted = new JSONArray();
        long lm = 0L;
        for (Group group : modifiedGroups) {
            temp = new JSONObject();
            groupWriter.writeGroup(group, temp);
            modified.put((Object)temp);
            lm = group.getLastModified().getTime() > lm ? group.getLastModified().getTime() : lm;
        }
        for (Group group : deletedGroups) {
            temp = new JSONObject();
            groupWriter.writeGroup(group, temp);
            deleted.put((Object)temp);
            lm = group.getLastModified().getTime() > lm ? group.getLastModified().getTime() : lm;
        }
        this.timestamp = new Date(lm);
        JSONObject retVal = new JSONObject();
        retVal.put("new", (Object)modified);
        retVal.put("modified", (Object)modified);
        retVal.put("deleted", (Object)deleted);
        return retVal;
    }

    public JSONArray actionList(JSONObject jsonObj) throws JSONException, OXException {
        JSONArray jsonArray = DataParser.checkJSONArray(jsonObj, "data");
        this.timestamp = new Date(0L);
        Date lastModified = null;
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < jsonArray.length(); ++a) {
            JSONObject jData = jsonArray.getJSONObject(a);
            Group group = groupStorage.getGroup(DataParser.checkInt(jData, "id"), this.session.getContext());
            JSONObject jsonGroupObj = new JSONObject();
            groupWriter.writeGroup(group, jsonGroupObj);
            jsonResponseArray.put((Object)jsonGroupObj);
            lastModified = group.getLastModified();
            if (this.timestamp.getTime() >= lastModified.getTime()) continue;
            this.timestamp = lastModified;
        }
        return jsonResponseArray;
    }

    public JSONObject actionGet(JSONObject json) throws JSONException, OXException, OXException, OXException {
        int groupId = DataParser.checkInt(json, "id");
        this.timestamp = new Date(0L);
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group group = groupStorage.getGroup(groupId, this.session.getContext());
        GroupWriter groupWriter = new GroupWriter();
        JSONObject retval = new JSONObject();
        groupWriter.writeGroup(group, retval);
        this.timestamp = group.getLastModified();
        return retval;
    }

    public JSONArray actionSearch(JSONObject jsonObj) throws JSONException, OXException {
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        String searchpattern = null;
        if (jData.has("pattern")) {
            searchpattern = DataParser.parseString(jData, "pattern");
        }
        this.timestamp = new Date(0L);
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = null;
        groups = "*".equals(searchpattern) ? groupStorage.getGroups(true, this.session.getContext()) : groupStorage.searchGroups(searchpattern, true, this.session.getContext());
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < groups.length; ++a) {
            JSONObject jsonGroupObj = new JSONObject();
            groupWriter.writeGroup(groups[a], jsonGroupObj);
            if (groups[a].getLastModified().after(this.timestamp)) {
                this.timestamp = groups[a].getLastModified();
            }
            jsonResponseArray.put((Object)jsonGroupObj);
        }
        return jsonResponseArray;
    }

    public JSONArray actionAll(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        String[] sColumns = DataParser.checkString(jsonObj, "columns").split(",");
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        boolean loadMembers = false;
        LinkedList<Group.Field> fields = new LinkedList<Group.Field>();
        for (int column : columns) {
            Group.Field field = Group.Field.getByColumnNumber(column);
            if (field == Group.Field.MEMBERS) {
                loadMembers = true;
            }
            fields.add(field);
        }
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = null;
        groups = groupStorage.getGroups(loadMembers, this.session.getContext());
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < groups.length; ++a) {
            JSONArray row = new JSONArray();
            groupWriter.writeArray(groups[a], row, fields);
            if (groups[a].getLastModified().after(this.timestamp)) {
                this.timestamp = groups[a].getLastModified();
            }
            jsonResponseArray.put((Object)row);
        }
        return jsonResponseArray;
    }
}

