/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.container.Response;
import com.openexchange.exception.Categories;
import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Component;
import com.openexchange.groupware.EnumComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseParser {
    private ResponseParser() {
    }

    public static Response parse(String body) throws JSONException {
        return ResponseParser.parse(new JSONObject(body));
    }

    public static Response parse(JSONObject json) throws JSONException {
        Response retval = new Response(json);
        ResponseParser.parse(retval, json);
        return retval;
    }

    public static void parse(Response response, JSONObject json) throws JSONException {
        if (json.has("data")) {
            response.setData(json.get("data"));
        }
        if (json.has("timestamp")) {
            response.setTimestamp(new Date(json.getLong("timestamp")));
        }
        String message = json.optString("error", null);
        String code = json.optString("code", null);
        if (message != null || code != null) {
            OXException exception;
            List<Category> categories;
            String prefix = ResponseParser.parseComponent(code);
            int number = ResponseParser.parseErrorNumber(code);
            Object jsonCategories = json.opt("categories");
            if (jsonCategories instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)jsonCategories;
                int length = jsonArray.length();
                categories = new ArrayList<Category>(length);
                for (int i = 0; i < length; ++i) {
                    categories.add(Categories.getKnownCategoryByName((String)jsonArray.getString(i)));
                }
                OXException.sortCategories(categories);
            } else {
                categories = jsonCategories != null ? Collections.singletonList(Categories.getKnownCategoryByName((String)jsonCategories.toString())) : Arrays.asList(Category.CATEGORY_ERROR);
            }
            Object[] args = ResponseParser.parseErrorMessageArgs(json.optJSONArray("error_params"));
            Category category = categories.get(0);
            if (category.getLogLevel().implies(LogLevel.DEBUG)) {
                exception = new OXException(number, message, args);
            } else {
                exception = new OXException(number, Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "An error occurred. Please try again later." : "A severe error occurred.", args);
                exception.setLogMessage(message);
            }
            exception.setPrefix(prefix);
            for (Category cat : categories) {
                exception.addCategory(cat);
            }
            if (Category.CATEGORY_WARNING.equals(category)) {
                response.addWarning(exception);
            } else {
                response.setException(exception);
            }
            if (json.has("error_id")) {
                exception.setExceptionId(json.getString("error_id"));
            }
            ResponseParser.parseProblematics(json.optJSONArray("problematic"), exception);
        }
    }

    private static String parseComponent(String code) {
        if (code == null || code.length() == 0) {
            return EnumComponent.NONE.getAbbreviation();
        }
        int pos = code.indexOf(45);
        if (pos != -1) {
            String abbr = code.substring(0, pos);
            EnumComponent component = EnumComponent.byAbbreviation((String)abbr);
            if (component != null) {
                return component.getAbbreviation();
            }
            return abbr;
        }
        return EnumComponent.NONE.getAbbreviation();
    }

    private static int parseErrorNumber(String code) {
        if (code == null || code.length() == 0) {
            return 0;
        }
        int pos = code.indexOf(45);
        if (pos != -1) {
            try {
                return Integer.parseInt(code.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private static Object[] parseErrorMessageArgs(JSONArray jArgs) {
        if (null != jArgs) {
            Object[] args = new Object[jArgs.length()];
            for (int i = 0; i < jArgs.length(); ++i) {
                args[i] = jArgs.opt(i);
            }
            return args;
        }
        return new Object[0];
    }

    private static void parseProblematics(JSONArray probs, OXException exc) throws JSONException {
        if (null == probs) {
            return;
        }
        ArrayList<Object> problematics = new ArrayList<Object>();
        for (int i = 0; i < probs.length(); ++i) {
            JSONObject jSONObject = probs.getJSONObject(i);
            if (jSONObject.has("id")) {
                problematics.add(ResponseParser.parseTruncated(jSONObject));
                continue;
            }
            if (!jSONObject.has("name")) continue;
            problematics.add(ResponseParser.parseParsing(jSONObject));
        }
        for (OXException.ProblematicAttribute problematicAttribute : problematics) {
            exc.addProblematic(problematicAttribute);
        }
    }

    private static OXException.Truncated parseTruncated(JSONObject json) throws JSONException {
        final int id = json.getInt("id");
        return new OXException.Truncated(){

            public int getId() {
                return id;
            }

            public int getLength() {
                return 0;
            }

            public int getMaxSize() {
                return 0;
            }
        };
    }

    private static OXException.Parsing parseParsing(JSONObject json) throws JSONException {
        final String attribute = json.getString("name");
        return new OXException.Parsing(){

            public String getAttribute() {
                return attribute;
            }
        };
    }

    public static final class StringComponent
    implements Component {
        private static final long serialVersionUID = 1159589477110476030L;
        private final String abbr;

        public StringComponent(String abbr) {
            this.abbr = abbr;
        }

        public String getAbbreviation() {
            return this.abbr;
        }
    }
}

