/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONAttachmentMetadata
implements AttachmentMetadata {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(JSONAttachmentMetadata.class));
    private final JSONObject json;

    public JSONAttachmentMetadata(String jsonString) throws JSONException {
        this.json = new JSONObject(jsonString);
    }

    public JSONAttachmentMetadata() {
        this.json = new JSONObject();
    }

    @Override
    public int getCreatedBy() {
        if (this.json.has(AttachmentField.CREATED_BY_LITERAL.getName())) {
            return this.json.optInt(AttachmentField.CREATED_BY_LITERAL.getName());
        }
        return -1;
    }

    @Override
    public void setCreatedBy(int createdBy) {
        try {
            this.json.put(AttachmentField.CREATED_BY_LITERAL.getName(), createdBy);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public Date getCreationDate() {
        if (!this.json.has(AttachmentField.CREATION_DATE_LITERAL.getName())) {
            return null;
        }
        return new Date(this.json.optLong(AttachmentField.CREATION_DATE_LITERAL.getName()));
    }

    @Override
    public void setCreationDate(Date creationDate) {
        if (creationDate == null && this.json.has(AttachmentField.CREATION_DATE_LITERAL.getName())) {
            this.json.remove(AttachmentField.CREATION_DATE_LITERAL.getName());
        } else if (creationDate != null) {
            try {
                this.json.put(AttachmentField.CREATION_DATE_LITERAL.getName(), creationDate.getTime());
            }
            catch (JSONException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public String getFileMIMEType() {
        if (!this.json.has(AttachmentField.FILE_MIMETYPE_LITERAL.getName())) {
            return null;
        }
        return this.json.optString(AttachmentField.FILE_MIMETYPE_LITERAL.getName());
    }

    @Override
    public void setFileMIMEType(String fileMIMEType) {
        if (fileMIMEType == null && this.json.has(AttachmentField.FILE_MIMETYPE_LITERAL.getName())) {
            this.json.remove(AttachmentField.FILE_MIMETYPE_LITERAL.getName());
            return;
        }
        try {
            this.json.put(AttachmentField.FILE_MIMETYPE_LITERAL.getName(), (Object)fileMIMEType);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public String getFilename() {
        if (!this.json.has(AttachmentField.FILENAME_LITERAL.getName())) {
            return null;
        }
        return this.json.optString(AttachmentField.FILENAME_LITERAL.getName());
    }

    @Override
    public void setFilename(String filename) {
        if (filename == null && this.json.has(AttachmentField.FILENAME_LITERAL.getName())) {
            this.json.remove(AttachmentField.FILENAME_LITERAL.getName());
            return;
        }
        try {
            this.json.put(AttachmentField.FILENAME_LITERAL.getName(), (Object)filename);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public long getFilesize() {
        if (!this.json.has(AttachmentField.FILE_SIZE_LITERAL.getName())) {
            return 0L;
        }
        return this.json.optLong(AttachmentField.FILE_SIZE_LITERAL.getName());
    }

    @Override
    public void setFilesize(long filesize) {
        try {
            this.json.put(AttachmentField.FILE_SIZE_LITERAL.getName(), filesize);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getAttachedId() {
        if (!this.json.has(AttachmentField.ATTACHED_ID_LITERAL.getName())) {
            return -1;
        }
        return this.json.optInt(AttachmentField.ATTACHED_ID_LITERAL.getName());
    }

    @Override
    public void setAttachedId(int objectId) {
        try {
            this.json.put(AttachmentField.ATTACHED_ID_LITERAL.getName(), objectId);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public boolean getRtfFlag() {
        return this.json.optBoolean(AttachmentField.RTF_FLAG_LITERAL.getName());
    }

    @Override
    public void setRtfFlag(boolean rtfFlag) {
        try {
            this.json.put(AttachmentField.RTF_FLAG_LITERAL.getName(), rtfFlag);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getModuleId() {
        if (!this.json.has(AttachmentField.MODULE_ID_LITERAL.getName())) {
            return -1;
        }
        return this.json.optInt(AttachmentField.MODULE_ID_LITERAL.getName());
    }

    @Override
    public void setModuleId(int moduleId) {
        try {
            this.json.put(AttachmentField.MODULE_ID_LITERAL.getName(), moduleId);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getId() {
        if (!this.json.has(AttachmentField.ID_LITERAL.getName())) {
            return -1;
        }
        return this.json.optInt(AttachmentField.ID_LITERAL.getName());
    }

    @Override
    public void setId(int id) {
        try {
            this.json.put(AttachmentField.ID_LITERAL.getName(), id);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public void setFolderId(int folderId) {
        try {
            this.json.put(AttachmentField.FOLDER_ID_LITERAL.getName(), folderId);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getFolderId() {
        if (!this.json.has(AttachmentField.FOLDER_ID_LITERAL.getName())) {
            return -1;
        }
        return this.json.optInt(AttachmentField.FOLDER_ID_LITERAL.getName());
    }

    public String toString() {
        return this.json.toString();
    }

    public String toJSONString() {
        return this.json.toString();
    }

    @Override
    public void setComment(String string) {
        if (null == string) {
            try {
                this.json.put(AttachmentField.COMMENT_LITERAL.getName(), JSONObject.NULL);
                return;
            }
            catch (JSONException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
        try {
            this.json.put(AttachmentField.COMMENT_LITERAL.getName(), (Object)string);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }

    @Override
    public String getComment() {
        return this.json.optString(AttachmentField.COMMENT_LITERAL.getName());
    }

    @Override
    public String getFileId() {
        return this.json.optString(AttachmentField.FILE_ID_LITERAL.getName());
    }

    @Override
    public void setFileId(String string) {
        if (null == string) {
            try {
                this.json.put(AttachmentField.COMMENT_LITERAL.getName(), JSONObject.NULL);
                return;
            }
            catch (JSONException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
        try {
            this.json.put(AttachmentField.FILE_ID_LITERAL.getName(), (Object)string);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
    }
}

