/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.JSONAttachmentMetadata;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import org.json.JSONException;

public class AttachmentParser {
    public AttachmentMetadata getAttachmentMetadata(String json) throws JSONException {
        return new JSONAttachmentMetadata(json);
    }

    public AttachmentField[] getColumns(String[] parameterValues) throws UnknownColumnException {
        if (parameterValues == null) {
            return null;
        }
        AttachmentField[] columns = new AttachmentField[parameterValues.length];
        int i = 0;
        for (String idString : parameterValues) {
            int id = -1;
            try {
                id = Integer.parseInt(idString);
            }
            catch (NumberFormatException x) {
                throw new UnknownColumnException(idString);
            }
            AttachmentField f = AttachmentField.get(id);
            if (f == null) {
                throw new UnknownColumnException(idString);
            }
            columns[i++] = f;
        }
        return columns;
    }

    public static final class UnknownColumnException
    extends OXException {
        private static final long serialVersionUID = -6760923740785771286L;
        private final String idString;

        public UnknownColumnException(String idString) {
            this.idString = idString;
        }

        public String getColumn() {
            return this.idString;
        }
    }
}

